/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.VerticalConveyor;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class VerticalCoveredConveyor
extends VerticalConveyor {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "verticalcovered");
    private static final CachedShapesWithTransform<Byte, Direction> SHAPES = CachedShapesWithTransform.createDirectional(VerticalCoveredConveyor::getBoxes);

    public VerticalCoveredConveyor(TileEntity tile) {
        super(tile);
    }

    @Override
    public boolean isCovered() {
        return true;
    }

    @Override
    public VoxelShape getCollisionShape() {
        return SHAPES.get(Pair.of((Object)this.buildCollisionState(), (Object)this.getFacing()));
    }

    private byte buildCollisionState() {
        byte out = 0;
        if (VerticalCoveredConveyor.renderBottomBelt(this.getTile(), this.getFacing())) {
            out = (byte)(out | 1);
        }
        if (this.renderBottomWall(this.getTile(), this.getFacing(), 0)) {
            out = (byte)(out | 2);
        }
        if (this.renderBottomWall(this.getTile(), this.getFacing(), 1)) {
            out = (byte)(out | 4);
        }
        if (!VerticalCoveredConveyor.isInwardConveyor(this.getTile(), this.getFacing().func_176734_d())) {
            out = (byte)(out | 8);
        }
        return out;
    }

    private static List<AxisAlignedBB> getBoxes(Byte state) {
        boolean bottom = (state & 1) != 0;
        boolean left = (state & 2) != 0;
        boolean right = (state & 4) != 0;
        boolean front = (state & 8) != 0;
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125));
        list.add(new AxisAlignedBB(0.0, left ? 0.0 : 0.75, 0.0, 0.0625, 1.0, 1.0));
        list.add(new AxisAlignedBB(0.9375, right ? 0.0 : 0.75, 0.0, 1.0, 1.0, 1.0));
        list.add(new AxisAlignedBB(0.0, front ? 0.0 : 0.75, 0.9375, 1.0, 1.0, 1.0));
        if (bottom || list.isEmpty()) {
            list.add(conveyorBounds.func_197752_a());
        }
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
        boolean[] walls;
        boolean renderBottom;
        boolean bl = renderBottom = this.getTile() != null && VerticalCoveredConveyor.renderBottomBelt(this.getTile(), this.getFacing());
        if (renderBottom) {
            TextureAtlasSprite sprite = ClientUtils.getSprite(this.isActive() ? BasicConveyor.texture_on : BasicConveyor.texture_off);
            TextureAtlasSprite spriteColour = ClientUtils.getSprite(this.getColouredStripesTexture());
            walls = new boolean[]{this.renderBottomWall(this.getTile(), this.getFacing(), 0), this.renderBottomWall(this.getTile(), this.getFacing(), 1)};
            baseModel.addAll(ModelConveyor.getBaseConveyor(this.getFacing(), 0.875f, ClientUtils.rotateTo(this.getFacing()), ConveyorHandler.ConveyorDirection.HORIZONTAL, sprite, walls, new boolean[]{true, false}, spriteColour, this.getDyeColour()));
        } else {
            walls = new boolean[]{true, true};
        }
        Block b = this.cover != Blocks.field_150350_a ? this.cover : VerticalCoveredConveyor.getDefaultCover();
        BlockState state = b.func_176223_P();
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (model != null) {
            TextureAtlasSprite sprite = model.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
            HashMap<Direction, TextureAtlasSprite> sprites = new HashMap<Direction, TextureAtlasSprite>();
            for (Direction f2 : Direction.field_199792_n) {
                for (BakedQuad q : model.func_200117_a(state, f2, Utils.RAND)) {
                    if (q == null || q.func_187508_a() == null) continue;
                    sprites.put(f2, q.func_187508_a());
                }
            }
            for (BakedQuad q : model.func_200117_a(state, null, Utils.RAND)) {
                if (q == null || q.func_187508_a() == null || q.func_178210_d() == null) continue;
                sprites.put(q.func_178210_d(), q.func_187508_a());
            }
            Function<Direction, TextureAtlasSprite> getSprite = f -> sprites.getOrDefault(f, sprite);
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            Matrix4 matrix = new Matrix4(this.getFacing());
            if (!renderBottom) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.0, 0.75), new Vec3d(1.0, 1.0, 1.0), matrix, this.getFacing(), getSprite, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.0, 0.1875), new Vec3d(0.0625, 1.0, 0.75), matrix, this.getFacing(), getSprite, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.9375, 0.0, 0.1875), new Vec3d(1.0, 1.0, 0.75), matrix, this.getFacing(), getSprite, colour));
            } else {
                boolean straightInput = this.getTile() != null && VerticalCoveredConveyor.isInwardConveyor(this.getTile(), this.getFacing().func_176734_d());
                baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.9375, 0.75), new Vec3d(1.0, 1.0, 1.0), matrix, this.getFacing(), getSprite, colour));
                if (!straightInput) {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.1875, 0.9375), new Vec3d(1.0, 1.0, 1.0), matrix, this.getFacing(), getSprite, colour));
                } else {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.75, 0.9375), new Vec3d(1.0, 1.0, 1.0), matrix, this.getFacing(), getSprite, colour));
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.1875, 0.9375), new Vec3d(0.0625, 0.75, 1.0), matrix, this.getFacing(), getSprite, colour));
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.9375, 0.1875, 0.9375), new Vec3d(1.0, 0.75, 1.0), matrix, this.getFacing(), getSprite, colour));
                }
                if (walls[0]) {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.1875, 0.1875), new Vec3d(0.0625, 1.0, 0.9375), matrix, this.getFacing(), getSprite, colour));
                } else {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.0, 0.75, 0.1875), new Vec3d(0.0625, 1.0, 0.9375), matrix, this.getFacing(), getSprite, colour));
                }
                if (walls[1]) {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.9375, 0.1875, 0.1875), new Vec3d(1.0, 1.0, 0.9375), matrix, this.getFacing(), getSprite, colour));
                } else {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vec3d(0.9375, 0.75, 0.1875), new Vec3d(1.0, 1.0, 0.9375), matrix, this.getFacing(), getSprite, colour));
                }
            }
        }
        return baseModel;
    }
}

