/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WatermillTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IHasObjProperty {
    public int[] offset = new int[]{0, 0};
    public float rotation = 0.0f;
    private Vec3d rotationVec = null;
    public boolean canTurn = false;
    public boolean multiblock = false;
    public float prevRotation = 0.0f;
    private boolean formed = true;
    public double perTick;
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;

    public WatermillTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.WATERMILL.get()));
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (this.offset[0] != 0 || this.offset[1] != 0 || this.field_145850_b == null) {
            return;
        }
        if (this.isBlocked()) {
            this.canTurn = false;
            return;
        }
        boolean bl = this.canTurn = this.multiblock || this.getRotationVec().func_72433_c() != 0.0;
        if (this.field_145850_b.func_82737_E() % 64L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x3F)) {
            this.rotationVec = null;
        }
        this.prevRotation = this.rotation;
        TileEntity acc = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(this.getFacing().func_176734_d()));
        if (!this.multiblock && acc instanceof IRotationAcceptor) {
            double power = this.getPower();
            int l = 1;
            TileEntity tileEntity = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177967_a(this.getFacing(), l));
            while (l < 3 && this.canUse(tileEntity)) {
                power += ((WatermillTileEntity)tileEntity).getPower();
                tileEntity = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177967_a(this.getFacing(), ++l));
            }
            this.perTick = 6.944444612599909E-4 * power / (double)l;
            this.canTurn = this.perTick != 0.0;
            this.rotation = (float)((double)this.rotation + this.perTick);
            this.rotation %= 1.0f;
            for (int l2 = 1; l2 < l; ++l2) {
                tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.getFacing(), l2));
                if (!(tileEntity instanceof WatermillTileEntity)) continue;
                ((WatermillTileEntity)tileEntity).rotation = this.rotation;
                ((WatermillTileEntity)tileEntity).canTurn = this.canTurn;
                ((WatermillTileEntity)tileEntity).perTick = this.perTick;
                ((WatermillTileEntity)tileEntity).multiblock = true;
            }
            if (!this.field_145850_b.field_72995_K) {
                IRotationAcceptor dynamo = (IRotationAcceptor)acc;
                dynamo.inputRotation(Math.abs(power * 0.75), this.getFacing().func_176734_d());
            }
        } else if (!this.multiblock) {
            this.perTick = 6.944444612599909E-4 * this.getPower();
            this.canTurn = this.perTick != 0.0;
            this.rotation = (float)((double)this.rotation + this.perTick);
            this.rotation %= 1.0f;
        }
        if (this.multiblock) {
            this.multiblock = false;
        }
    }

    private boolean canUse(@Nullable TileEntity tileEntity) {
        return tileEntity instanceof WatermillTileEntity && ((WatermillTileEntity)tileEntity).offset[0] == 0 && ((WatermillTileEntity)tileEntity).offset[1] == 0 && (((WatermillTileEntity)tileEntity).getFacing() == this.getFacing() || ((WatermillTileEntity)tileEntity).getFacing() == this.getFacing().func_176734_d()) && !((WatermillTileEntity)tileEntity).isBlocked() && !((WatermillTileEntity)tileEntity).multiblock;
    }

    public boolean isBlocked() {
        if (this.field_145850_b == null) {
            return true;
        }
        for (Direction fdY : new Direction[]{Direction.UP, Direction.DOWN}) {
            Direction[] directionArray;
            if (this.getFacing().func_176740_k() == Direction.Axis.Z) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.EAST;
                directionArray = directionArray2;
                directionArray2[1] = Direction.WEST;
            } else {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.SOUTH;
                directionArray = directionArray3;
                directionArray3[1] = Direction.NORTH;
            }
            for (Direction fdW : directionArray) {
                BlockPos pos = this.func_174877_v().func_177967_a(fdW, 2).func_177967_a(fdY, 2);
                BlockState state = this.field_145850_b.func_180495_p(pos);
                if (Block.func_208061_a((VoxelShape)state.func_196954_c((IBlockReader)this.field_145850_b, pos), (Direction)fdW.func_176734_d())) {
                    return true;
                }
                if (!Block.func_208061_a((VoxelShape)state.func_196954_c((IBlockReader)this.field_145850_b, pos), (Direction)fdY.func_176734_d())) continue;
                return true;
            }
        }
        return false;
    }

    public double getPower() {
        return this.getFacing().func_176740_k() == Direction.Axis.Z ? -this.getRotationVec().field_72450_a : this.getRotationVec().field_72449_c;
    }

    public Vec3d getRotationVec() {
        if (this.rotationVec == null) {
            this.rotationVec = new Vec3d(0.0, 0.0, 0.0);
            Vec3d dirHoz = this.getHorizontalVec();
            Vec3d dirVer = this.getVerticalVec();
            this.rotationVec = Utils.addVectors(this.rotationVec, dirHoz);
            this.rotationVec = Utils.addVectors(this.rotationVec, dirVer);
        }
        return this.rotationVec;
    }

    private Vec3d getHorizontalVec() {
        Vec3d dir = new Vec3d(0.0, 0.0, 0.0);
        boolean faceZ = this.getFacing().ordinal() <= 3;
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 1 : 0), 3, -(faceZ ? 0 : 1))));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(0, 3, 0)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 1 : 0, 3, faceZ ? 0 : 1)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 2 : 0), 2, -(faceZ ? 0 : 2))));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 2 : 0, 2, faceZ ? 0 : 2)));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 2 : 0), -2, -(faceZ ? 0 : 2))));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 2 : 0, -2, faceZ ? 0 : 2)));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 1 : 0), -3, -(faceZ ? 0 : 1))));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(0, -3, 0)));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 1 : 0, -3, faceZ ? 0 : 1)));
        return dir;
    }

    private Vec3d getVerticalVec() {
        Vec3d dir = new Vec3d(0.0, 0.0, 0.0);
        Vec3d dirNeg = new Vec3d(0.0, 0.0, 0.0);
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 0), 2, -(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 2))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0), 1, -(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0), 0, -(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0), -1, -(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 0), -2, -(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 2))));
        Vec3d dirPos = new Vec3d(0.0, 0.0, 0.0);
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 0, 2, this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 2)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0, 1, this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0, 0, this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0, -1, this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 0, -2, this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 2)));
        dir = this.getFacing().func_176740_k() == Direction.Axis.Z ? dir.func_72441_c(dirNeg.field_72448_b - dirPos.field_72448_b, 0.0, 0.0) : dir.func_72441_c(0.0, 0.0, dirNeg.field_72448_b - dirPos.field_72448_b);
        return dir;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        this.rotationVec = new Vec3d((double)((float)id / 10000.0f), 0.0, (double)((float)arg / 10000.0f));
        return true;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.prevRotation = nbt.func_74760_g("prevRotation");
        this.offset = nbt.func_74759_k("offset");
        this.rotation = nbt.func_74760_g("rotation");
        if (this.offset == null || this.offset.length < 2) {
            this.offset = new int[]{0, 0};
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74776_a("prevRotation", this.prevRotation);
        nbt.func_74783_a("offset", this.offset);
        nbt.func_74776_a("rotation", this.rotation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offset[0] == 0 && this.offset[1] == 0 ? new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 0)), (double)(this.func_174877_v().func_177956_o() - 2), (double)(this.func_174877_v().func_177952_p() - (this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 2)), (double)(this.func_174877_v().func_177958_n() + (this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0)), (double)(this.func_174877_v().func_177956_o() + 3), (double)(this.func_174877_v().func_177952_p() + (this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : 3))) : new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
        }
        return this.renderAABB;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : -this.offset[0]);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        state = (BlockState)state.func_206870_a((IProperty)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || hh == 0 && ww == 0) continue;
                BlockPos pos2 = this.field_174879_c.func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? ww : 0, hh, this.getFacing().func_176740_k() == Direction.Axis.Z ? 0 : ww);
                this.field_145850_b.func_175656_a(pos2, state);
                WatermillTileEntity dummy = (WatermillTileEntity)this.field_145850_b.func_175625_s(pos2);
                dummy.setFacing(this.getFacing());
                dummy.offset = new int[]{ww, hh};
            }
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        if (!this.formed) {
            return;
        }
        BlockPos initPos = pos.func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.getFacing().func_176740_k() == Direction.Axis.X ? -this.offset[0] : 0);
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                BlockPos pos2;
                TileEntity te;
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || !((te = this.field_145850_b.func_175625_s(pos2 = initPos.func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? ww : 0, hh, this.getFacing().func_176740_k() == Direction.Axis.X ? ww : 0))) instanceof WatermillTileEntity)) continue;
                ((WatermillTileEntity)te).formed = false;
                this.field_145850_b.func_217377_a(pos2, false);
            }
        }
    }

    @Override
    public IEProperties.VisibilityList compileDisplayList(BlockState state) {
        return IEProperties.VisibilityList.hideAll();
    }
}

