/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SpeedloaderLoadRecipe
extends SpecialRecipe {
    private final byte[] offsetPattern = new byte[]{0, 1, 1, 1, 0, -1, -1, -1};

    public SpeedloaderLoadRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(CraftingInventory inv, @Nonnull World world) {
        ItemStack stackInSlot;
        int i;
        int speedloaderX = -1;
        int speedloaderY = -1;
        boolean hasSpeedloader = false;
        NonNullList<ItemStack> speedloaderBullets = null;
        boolean hasBullets = false;
        int width = inv.func_174922_i();
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof SpeedloaderItem) {
                if (hasSpeedloader) {
                    return false;
                }
                if (!((SpeedloaderItem)stackInSlot.func_77973_b()).isEmpty(stackInSlot)) {
                    speedloaderBullets = ((SpeedloaderItem)stackInSlot.func_77973_b()).getBullets(stackInSlot, false);
                }
                speedloaderX = i % width;
                speedloaderY = i / width;
                hasSpeedloader = true;
                continue;
            }
            if (stackInSlot.func_77973_b() instanceof BulletItem) {
                hasBullets = true;
                continue;
            }
            return false;
        }
        if (hasSpeedloader && hasBullets) {
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                stackInSlot = inv.func_70301_a(i);
                if (stackInSlot.func_190926_b()) continue;
                int curOffsetY = i / width - speedloaderY;
                int curOffsetX = i % width - speedloaderX;
                if (curOffsetY == 0 && curOffsetX == 0 || Math.abs(curOffsetY) <= 1 && Math.abs(curOffsetX) <= 1 && (speedloaderBullets == null || ((ItemStack)speedloaderBullets.get(3 + (curOffsetX > 0 || curOffsetX == 0 && curOffsetY < 0 ? 1 : -1) * (curOffsetX + curOffsetY - 2))).func_190926_b())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack speedloader = null;
        int speedloaderX = -1;
        int speedloaderY = -1;
        int width = inv.func_174922_i();
        int height = inv.func_174923_h();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!(inv.func_70301_a(i).func_77973_b() instanceof SpeedloaderItem)) continue;
            speedloader = inv.func_70301_a(i);
            speedloaderX = i % width;
            speedloaderY = i / width;
            break;
        }
        ItemStack out = speedloader.func_77946_l();
        NonNullList<ItemStack> fill = ((SpeedloaderItem)out.func_77973_b()).getBullets(out, false);
        for (int i = 0; i < 8; ++i) {
            ItemStack curBullet;
            int curX;
            int curY = speedloaderY + this.offsetPattern[(i + 6) % 8];
            if (curY < 0 || curY >= height || (curX = speedloaderX + this.offsetPattern[i]) < 0 || curX >= width || (curBullet = inv.func_70301_a(width * curY + curX)).func_190926_b()) continue;
            fill.set(i, (Object)Utils.copyStackWithAmount(curBullet, 1));
        }
        ((SpeedloaderItem)out.func_77973_b()).setContainedItems(out, fill);
        return out;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.SPEEDLOADER_LOAD.get();
    }
}

