/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class TurnAndCopyRecipeBuilder
extends ShapedRecipeBuilder {
    private boolean allowQuarterTurn = false;
    private boolean allowEighthTurn = false;
    private int[] nbtCopyTargetSlot = null;
    private Pattern nbtCopyPredicate = null;

    public TurnAndCopyRecipeBuilder(IItemProvider result, int count) {
        super(result, count);
    }

    public static TurnAndCopyRecipeBuilder builder(IItemProvider result, int count) {
        return new TurnAndCopyRecipeBuilder(result, count);
    }

    public static TurnAndCopyRecipeBuilder builder(IItemProvider result) {
        return new TurnAndCopyRecipeBuilder(result, 1);
    }

    public TurnAndCopyRecipeBuilder allowQuarterTurn() {
        this.allowQuarterTurn = true;
        return this;
    }

    public TurnAndCopyRecipeBuilder allowEighthTurn() {
        this.allowEighthTurn = true;
        return this;
    }

    public TurnAndCopyRecipeBuilder setNBTCopyTargetRecipe(int ... slot) {
        this.nbtCopyTargetSlot = slot;
        return this;
    }

    public TurnAndCopyRecipeBuilder setNBTCopyPredicate(String pattern) {
        this.nbtCopyPredicate = Pattern.compile(pattern);
        return this;
    }

    public void func_200467_a(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        Consumer<IFinishedRecipe> dummyConsumer = iFinishedRecipe -> {
            TurnAndCopyResult result = new TurnAndCopyResult((IFinishedRecipe)iFinishedRecipe, this.allowQuarterTurn, this.allowEighthTurn, this.nbtCopyTargetSlot, this.nbtCopyPredicate);
            consumerIn.accept(result);
        };
        super.func_200467_a(dummyConsumer, id);
    }

    public static class TurnAndCopyResult
    implements IFinishedRecipe {
        final IFinishedRecipe base;
        final boolean allowQuarterTurn;
        final boolean allowEighthTurn;
        final int[] nbtCopyTargetSlot;
        final Pattern nbtCopyPredicate;

        public TurnAndCopyResult(IFinishedRecipe base, boolean allowQuarterTurn, boolean allowEighthTurn, int[] nbtCopyTargetSlot, Pattern nbtCopyPredicate) {
            this.base = base;
            this.allowQuarterTurn = allowQuarterTurn;
            this.allowEighthTurn = allowEighthTurn;
            this.nbtCopyTargetSlot = nbtCopyTargetSlot;
            this.nbtCopyPredicate = nbtCopyPredicate;
        }

        public void func_218610_a(JsonObject json) {
            this.base.func_218610_a(json);
            if (this.allowQuarterTurn) {
                json.addProperty("quarter_turn", Boolean.valueOf(true));
            }
            if (this.allowEighthTurn) {
                json.addProperty("eighth_turn", Boolean.valueOf(true));
            }
            if (this.nbtCopyTargetSlot != null) {
                if (this.nbtCopyTargetSlot.length > 1) {
                    JsonArray jsonarray = new JsonArray();
                    for (int slot : this.nbtCopyTargetSlot) {
                        jsonarray.add((Number)slot);
                    }
                    json.add("copy_nbt", (JsonElement)jsonarray);
                } else {
                    json.addProperty("copy_nbt", (Number)this.nbtCopyTargetSlot[0]);
                }
                if (this.nbtCopyPredicate != null) {
                    json.addProperty("copy_nbt_predicate", this.nbtCopyPredicate.pattern());
                }
            }
        }

        public ResourceLocation func_200442_b() {
            return this.base.func_200442_b();
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)RecipeSerializers.TURN_AND_COPY_SERIALIZER.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.base.func_200440_c();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.base.func_200443_d();
        }
    }
}

