/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class MixerRecipeSerializer
extends IERecipeSerializer<MixerRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.mixer);
    }

    @Override
    public MixerRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        FluidStack fluidOutput = ApiUtils.jsonDeserializeFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        FluidTagInput fluidInput = FluidTagInput.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"fluid"));
        JsonArray inputs = json.getAsJsonArray("inputs");
        IngredientWithSize[] ingredients = new IngredientWithSize[inputs.size()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = IngredientWithSize.deserialize(inputs.get(i));
        }
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        return IEConfig.MACHINES.mixerConfig.apply(new MixerRecipe(recipeId, fluidOutput, fluidInput, ingredients, energy));
    }

    @Nullable
    public MixerRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        FluidStack fluidOutput = buffer.readFluidStack();
        FluidTagInput fluidInput = FluidTagInput.read(buffer);
        int ingredientCount = buffer.readInt();
        IngredientWithSize[] itemInputs = new IngredientWithSize[ingredientCount];
        for (int i = 0; i < ingredientCount; ++i) {
            itemInputs[i] = IngredientWithSize.read(buffer);
        }
        int energy = buffer.readInt();
        return new MixerRecipe(recipeId, fluidOutput, fluidInput, itemInputs, energy);
    }

    public void write(PacketBuffer buffer, MixerRecipe recipe) {
        buffer.writeFluidStack(recipe.fluidOutput);
        recipe.fluidInput.write(buffer);
        buffer.writeInt(recipe.itemInputs.length);
        for (IngredientWithSize input : recipe.itemInputs) {
            input.write(buffer);
        }
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

