/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class Villages {
    public static final ResourceLocation ENGINEER = new ResourceLocation("immersiveengineering", "engineer");
    public static final ResourceLocation MACHINIST = new ResourceLocation("immersiveengineering", "machinist");
    public static final ResourceLocation ELECTRICIAN = new ResourceLocation("immersiveengineering", "electrician");
    public static final ResourceLocation OUTFITTER = new ResourceLocation("immersiveengineering", "outfitter");
    public static final ResourceLocation GUNSMITH = new ResourceLocation("immersiveengineering", "gunsmith");

    public static void init() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            Villages.addToPool(new ResourceLocation("village/" + biome + "/houses"), IEDataGenerator.rl("village/houses/" + biome + "_engineer"), 4);
        }
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("immersiveengineering", "village/workstations"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)new Pair((Object)new SingleJigsawPiece("immersiveengineering:village/workstations/electrician"), (Object)1), (Object)new Pair((Object)new SingleJigsawPiece("immersiveengineering:village/workstations/engineer"), (Object)1), (Object)new Pair((Object)new SingleJigsawPiece("immersiveengineering:village/workstations/gunsmith"), (Object)1), (Object)new Pair((Object)new SingleJigsawPiece("immersiveengineering:village/workstations/machinist"), (Object)1), (Object)new Pair((Object)new SingleJigsawPiece("immersiveengineering:village/workstations/outfitter"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        GiveHeroGiftsTask.field_220403_a.put(Registers.PROF_ENGINEER.get(), IEDataGenerator.rl("gameplay/hero_of_the_village/engineer"));
        GiveHeroGiftsTask.field_220403_a.put(Registers.PROF_MACHINIST.get(), IEDataGenerator.rl("gameplay/hero_of_the_village/machinist"));
        GiveHeroGiftsTask.field_220403_a.put(Registers.PROF_ELECTRICIAN.get(), IEDataGenerator.rl("gameplay/hero_of_the_village/electrician"));
        GiveHeroGiftsTask.field_220403_a.put(Registers.PROF_OUTFITTER.get(), IEDataGenerator.rl("gameplay/hero_of_the_village/outfitter"));
        GiveHeroGiftsTask.field_220403_a.put(Registers.PROF_GUNSMITH.get(), IEDataGenerator.rl("gameplay/hero_of_the_village/gunsmith"));
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = JigsawManager.field_214891_a.func_214933_a(pool);
        List shuffled = old.func_214943_b(new Random(0L));
        Object2IntLinkedOpenHashMap newPieces = new Object2IntLinkedOpenHashMap();
        for (JigsawPiece p : shuffled) {
            newPieces.computeInt((Object)p, (pTemp, i) -> (i == null ? 0 : i) + 1);
        }
        newPieces.put((Object)new SingleJigsawPiece(toAdd.toString()), weight);
        List newPieceList = newPieces.object2IntEntrySet().stream().map(e -> Pair.of((Object)e.getKey(), (Object)e.getIntValue())).collect(Collectors.toList());
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(pool, old.func_214948_a(), newPieceList, JigsawPattern.PlacementBehaviour.RIGID));
    }

    private static class PriceInterval {
        private final int min;
        private final int max;

        private PriceInterval(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getPrice(Random rand) {
            return this.min >= this.max ? this.min : this.min + rand.nextInt(this.max - this.min + 1);
        }
    }

    private static class RevolverPieceForEmeralds
    implements VillagerTrades.ITrade {
        public MerchantOffer func_221182_a(Entity trader, @Nonnull Random random) {
            int part = random.nextInt(3);
            ItemStack stack = new ItemStack((IItemProvider)(part == 0 ? IEItems.Ingredients.gunpartBarrel : (part == 1 ? IEItems.Ingredients.gunpartDrum : IEItems.Ingredients.gunpartDrum)));
            float luck = 1.0f;
            if (trader instanceof AbstractVillagerEntity && ((AbstractVillagerEntity)trader).func_213716_dX()) {
                luck = ((AbstractVillagerEntity)trader).func_70931_l_().func_184817_da();
            }
            CompoundNBT perksTag = RevolverItem.RevolverPerk.generatePerkSet(random, luck);
            ItemNBTHelper.setTagCompound(stack, "perks", perksTag);
            int tier = Math.max(1, RevolverItem.RevolverPerk.calculateTier(perksTag));
            ItemNBTHelper.putBoolean(stack, "generatePerks", true);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 5 * tier + random.nextInt(5)), stack, 1, 30, 0.25f);
        }
    }

    private static class OreveinMapForEmeralds
    implements VillagerTrades.ITrade {
        public PriceInterval value;
        private static final int SEARCH_RADIUS = 512;

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, @Nonnull Random random) {
            World world = trader.func_130014_f_();
            BlockPos merchantPos = trader.func_180425_c();
            ArrayList<MineralVein> veins = new ArrayList<MineralVein>();
            for (int i = 0; i < 8; ++i) {
                int offZ;
                int offX = random.nextInt(1024) - 512;
                MineralVein vein = ExcavatorHandler.getRandomMineral(world, merchantPos.func_177982_a(offX, 0, offZ = random.nextInt(1024) - 512));
                if (vein == null || veins.contains(vein)) continue;
                veins.add(vein);
            }
            if (veins.size() > 0) {
                veins.sort(Comparator.comparingInt(o -> o.getMineral().weight));
                MineralVein vein = (MineralVein)veins.get(0);
                BlockPos blockPos = new BlockPos(vein.getPos().field_219439_a, 64, vein.getPos().field_219440_b);
                ItemStack selling = FilledMapItem.func_195952_a((World)world, (int)blockPos.func_177958_n(), (int)blockPos.func_177952_p(), (byte)1, (boolean)true, (boolean)true);
                FilledMapItem.func_219992_b((World)world, (ItemStack)selling);
                MapData.func_191094_a((ItemStack)selling, (BlockPos)blockPos, (String)"ie:coresample_treasure", (MapDecoration.Type)MapDecoration.Type.RED_X);
                selling.func_200302_a((ITextComponent)new TranslationTextComponent("item.immersiveengineering.map_orevein", new Object[0]));
                ItemNBTHelper.setLore(selling, new ITextComponent[]{new TranslationTextComponent(vein.getMineral().getTranslationKey(), new Object[0])});
                return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 8 + random.nextInt(8)), new ItemStack((IItemProvider)IEItems.Metals.ingots.get((Object)EnumMetals.STEEL), 4 + random.nextInt(8)), selling, 0, 1, 30, 0.5f);
            }
            return null;
        }
    }

    private static class ItemsForEmerald
    implements VillagerTrades.ITrade {
        public ItemStack sellingItem;
        public PriceInterval priceInfo;
        final int maxUses;
        final int xp;
        final float priceMult;

        public ItemsForEmerald(IItemProvider par1Item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this(new ItemStack(par1Item), priceInfo, maxUses, xp, priceMult);
        }

        public ItemsForEmerald(ItemStack par1Item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this.sellingItem = par1Item;
            this.priceInfo = priceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack selling;
            ItemStack buying;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.getPrice(rand);
            }
            if (i < 0) {
                buying = new ItemStack((IItemProvider)Items.field_151166_bC);
                selling = ItemUtils.copyStackWithAmount(this.sellingItem, -i);
            } else {
                buying = new ItemStack((IItemProvider)Items.field_151166_bC, i);
                selling = this.sellingItem;
            }
            return new MerchantOffer(buying, selling, this.maxUses, this.xp, this.priceMult);
        }
    }

    private static class EmeraldForItems
    implements VillagerTrades.ITrade {
        public ItemStack buyingItem;
        public PriceInterval buyAmounts;
        final int maxUses;
        final int xp;

        public EmeraldForItems(@Nonnull ItemStack item, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this.buyingItem = item;
            this.buyAmounts = buyAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public EmeraldForItems(@Nonnull IItemProvider item, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(new ItemStack(item), buyAmounts, maxUses, xp);
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(ItemUtils.copyStackWithAmount(this.buyingItem, this.buyAmounts.getPrice(rand)), new ItemStack((IItemProvider)Items.field_151166_bC), this.maxUses, this.xp, 0.05f);
        }
    }

    @Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent ev) {
            Int2ObjectMap trades = ev.getTrades();
            if (ENGINEER.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.stickTreated, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)TreatedWoodStyles.HORIZONTAL), new PriceInterval(-10, -6), 12, 1, 0.2f));
                ((List)trades.get(1)).add(new ItemsForEmerald((IItemProvider)IEBlocks.Cloth.balloon, new PriceInterval(-3, -1), 12, 1, 0.2f));
                ((List)trades.get(2)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.stickIron, new PriceInterval(2, 6), 12, 10));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(-8, -4), 12, 5, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(-8, -4), 12, 5, 0.2f));
                ((List)trades.get(3)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.stickSteel, new PriceInterval(2, 6), 12, 20));
                ((List)trades.get(3)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.slag, new PriceInterval(4, 8), 12, 20));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)IEBlocks.StoneDecoration.concrete, new PriceInterval(-6, -2), 12, 10, 0.2f));
                ((List)trades.get(4)).add(new OreveinMapForEmeralds());
            } else if (MACHINIST.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.coalCoke, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald((IItemProvider)IEItems.Tools.hammer, new PriceInterval(4, 7), 12, 1, 0.2f));
                ((List)trades.get(2)).add(new EmeraldForItems((IItemProvider)IEItems.Metals.ingots.get((Object)EnumMetals.COPPER), new PriceInterval(4, 6), 12, 10));
                ((List)trades.get(2)).add(new EmeraldForItems((IItemProvider)IEItems.Metals.ingots.get((Object)EnumMetals.ALUMINUM), new PriceInterval(4, 6), 12, 10));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)IEItems.Ingredients.componentSteel, new PriceInterval(1, 3), 12, 5, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)IEItems.Tools.toolbox, new PriceInterval(6, 8), 12, 10, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)IEItems.Ingredients.waterwheelSegment, new PriceInterval(1, 3), 12, 10, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald((IItemProvider)IEItems.Tools.drillheadIron, new PriceInterval(28, 40), 3, 15, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.earmuffs, new PriceInterval(4, 9), 3, 15, 0.2f));
                ((List)trades.get(5)).add(new ItemsForEmerald((IItemProvider)IEItems.Tools.drillheadSteel, new PriceInterval(32, 48), 3, 30, 0.2f));
                ((List)trades.get(5)).add(new ItemsForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("electrode"), new PriceInterval(12, 24), 3, 30, 0.2f));
            } else if (ELECTRICIAN.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.wireCopper, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald((IItemProvider)IEItems.Tools.wirecutter, new PriceInterval(4, 7), 12, 1, 0.2f));
                ((List)trades.get(1)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER), new PriceInterval(-4, -2), 12, 1, 0.2f));
                ((List)trades.get(2)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.wireElectrum, new PriceInterval(6, 12), 12, 10));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)IEItems.Tools.voltmeter, new PriceInterval(4, 7), 12, 5, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.wireCoils.get(WireType.ELECTRUM), new PriceInterval(-4, -1), 12, 5, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.faradaySuit.get(EquipmentSlotType.FEET), new PriceInterval(5, 7), 12, 5, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.faradaySuit.get(EquipmentSlotType.LEGS), new PriceInterval(9, 11), 12, 5, 0.2f));
                ((List)trades.get(3)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.wireAluminum, new PriceInterval(4, 8), 12, 20));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.wireCoils.get(WireType.STEEL), new PriceInterval(-2, -1), 12, 10, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.faradaySuit.get(EquipmentSlotType.CHEST), new PriceInterval(11, 15), 12, 10, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.faradaySuit.get(EquipmentSlotType.HEAD), new PriceInterval(5, 7), 12, 10, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.fluorescentTube, new PriceInterval(8, 12), 3, 15, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_ELECTRO), new PriceInterval(8, 12), 3, 15, 0.2f));
                ((List)trades.get(5)).add(new ItemsForEmerald((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_CAPACITORS), new PriceInterval(8, 12), 3, 30, 0.2f));
            } else if (OUTFITTER.equals((Object)ev.getType().getRegistryName())) {
                Item bag_common = IEItems.Misc.shaderBag.get(Rarity.COMMON);
                Item bag_uncommon = IEItems.Misc.shaderBag.get(Rarity.UNCOMMON);
                Item bag_rare = IEItems.Misc.shaderBag.get(Rarity.RARE);
                ((List)trades.get(1)).add(new ItemsForEmerald((IItemProvider)bag_common, new PriceInterval(8, 16), 24, 1, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)bag_uncommon, new PriceInterval(12, 20), 24, 5, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)bag_rare, new PriceInterval(16, 24), 24, 10, 0.2f));
            } else if (GUNSMITH.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.emptyCasing, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new EmeraldForItems((IItemProvider)IEItems.Ingredients.emptyShell, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald((IItemProvider)IEItems.Ingredients.woodenGrip, new PriceInterval(2, 4), 12, 1, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("bullet"), new PriceInterval(3, 6), 1, 25, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.CASULL), new PriceInterval(-4, -2), 12, 5, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.BUCKSHOT), new PriceInterval(-6, -2), 12, 5, 0.2f));
                ((List)trades.get(2)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(3)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(3)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.FLARE), new PriceInterval(-2, -1), 12, 10, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("specialBullet"), new PriceInterval(5, 9), 1, 30, 0.2f));
                ((List)trades.get(4)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(4)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.SILVER), new PriceInterval(-4, -1), 6, 15, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.HIGH_EXPLOSIVE), new PriceInterval(2, 4), 6, 15, 0.2f));
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registers {
        public static final DeferredRegister<PointOfInterestType> POINTS_OF_INTEREST = new DeferredRegister(ForgeRegistries.POI_TYPES, "immersiveengineering");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = new DeferredRegister(ForgeRegistries.PROFESSIONS, "immersiveengineering");
        public static final RegistryObject<PointOfInterestType> POI_CRAFTINGTABLE = POINTS_OF_INTEREST.register("craftingtable", () -> Registers.createPOI("craftingtable", Registers.assembleStates(IEBlocks.WoodenDevices.craftingTable)));
        public static final RegistryObject<PointOfInterestType> POI_ANVIL = POINTS_OF_INTEREST.register("anvil", () -> Registers.createPOI("anvil", Registers.assembleStates(Blocks.field_150467_bQ)));
        public static final RegistryObject<PointOfInterestType> POI_ENERGYMETER = POINTS_OF_INTEREST.register("energymeter", () -> Registers.createPOI("energymeter", Registers.assembleStates(IEBlocks.Connectors.currentTransformer)));
        public static final RegistryObject<PointOfInterestType> POI_BANNER = POINTS_OF_INTEREST.register("shaderbanner", () -> Registers.createPOI("shaderbanner", Registers.assembleStates(IEBlocks.Cloth.shaderBanner)));
        public static final RegistryObject<PointOfInterestType> POI_WORKBENCH = POINTS_OF_INTEREST.register("workbench", () -> Registers.createPOI("workbench", Registers.assembleStates(IEBlocks.WoodenDevices.workbench)));
        public static final RegistryObject<VillagerProfession> PROF_ENGINEER = PROFESSIONS.register(ENGINEER.func_110623_a(), () -> Registers.createProf(ENGINEER, (PointOfInterestType)POI_CRAFTINGTABLE.get(), SoundEvents.field_219703_mK));
        public static final RegistryObject<VillagerProfession> PROF_MACHINIST = PROFESSIONS.register(MACHINIST.func_110623_a(), () -> Registers.createProf(MACHINIST, (PointOfInterestType)POI_ANVIL.get(), SoundEvents.field_219705_mM));
        public static final RegistryObject<VillagerProfession> PROF_ELECTRICIAN = PROFESSIONS.register(ELECTRICIAN.func_110623_a(), () -> Registers.createProf(ELECTRICIAN, (PointOfInterestType)POI_ENERGYMETER.get(), IESounds.spark));
        public static final RegistryObject<VillagerProfession> PROF_OUTFITTER = PROFESSIONS.register(OUTFITTER.func_110623_a(), () -> Registers.createProf(OUTFITTER, (PointOfInterestType)POI_BANNER.get(), SoundEvents.field_219696_mD));
        public static final RegistryObject<VillagerProfession> PROF_GUNSMITH = PROFESSIONS.register(GUNSMITH.func_110623_a(), () -> Registers.createProf(GUNSMITH, (PointOfInterestType)POI_WORKBENCH.get(), IESounds.revolverReload));

        private static PointOfInterestType createPOI(String name, Collection<BlockState> block) {
            PointOfInterestType type = new PointOfInterestType("immersiveengineering:" + name, (Set)ImmutableSet.copyOf(block), 1, 1);
            PointOfInterestType.func_221052_a((PointOfInterestType)type);
            return type;
        }

        private static VillagerProfession createProf(ResourceLocation name, PointOfInterestType poi, SoundEvent sound) {
            return new VillagerProfession(name.toString(), poi, ImmutableSet.builder().build(), ImmutableSet.builder().build(), sound);
        }

        private static Collection<BlockState> assembleStates(Block block) {
            return block.func_176194_O().func_177619_a().stream().filter(blockState -> {
                if (blockState.func_196959_b((IProperty)IEProperties.MULTIBLOCKSLAVE)) {
                    return (Boolean)blockState.func_177229_b((IProperty)IEProperties.MULTIBLOCKSLAVE) == false;
                }
                return true;
            }).collect(Collectors.toList());
        }
    }
}

