/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ClickableList;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ManualScreen
extends Screen {
    private Minecraft mc = Minecraft.func_71410_x();
    private int xSize = 186;
    private int ySize = 198;
    private int guiLeft;
    private int guiTop;
    private int manualTick = 0;
    private List<Button> pageButtons = new ArrayList<Button>();
    @Nonnull
    public Tree.AbstractNode<ResourceLocation, ManualEntry> currentNode;
    public Stack<ManualInstance.ManualLink> previousSelectedEntry = new Stack();
    public int page;
    public static ManualScreen lastActiveManual;
    ManualInstance manual;
    ResourceLocation texture;
    private double[] lastClick;
    private double[] lastDrag;
    private TextFieldWidget searchField;
    private int prevGuiScale = -1;
    private ClickableList entryList;
    private ClickableList suggestionList;
    private final boolean setLastActive;

    public ManualScreen(ManualInstance manual, ResourceLocation texture) {
        this(manual, texture, true);
    }

    public ManualScreen(ManualInstance manual, ResourceLocation texture, boolean setLastActive) {
        super((ITextComponent)new StringTextComponent("manual"));
        this.manual = manual;
        this.currentNode = manual.getRoot();
        this.texture = texture;
        this.prevGuiScale = this.mc.field_71474_y.field_74335_Z;
        if (this.prevGuiScale != 0 && this.prevGuiScale != 2 && manual.allowGuiRescale()) {
            this.mc.field_71474_y.field_74335_Z = 2;
        }
        this.setLastActive = setLastActive;
    }

    public ManualEntry getCurrentPage() {
        return this.currentNode.getLeafData();
    }

    public void setCurrentNode(@Nonnull Tree.AbstractNode<ResourceLocation, ManualEntry> entry) {
        this.currentNode = entry;
        if (this.currentNode.isLeaf()) {
            this.manual.openEntry(this.currentNode.getLeafData());
        }
    }

    public ManualInstance getManual() {
        return this.manual;
    }

    public void init() {
        if (this.mc.field_71474_y.field_74335_Z == 1) {
            this.mc.field_71474_y.field_74335_Z = 2;
            this.width = this.mc.func_228018_at_().func_198107_o();
            this.height = this.mc.func_228018_at_().func_198087_p();
            this.mc.field_71474_y.field_74335_Z = 1;
        }
        this.manual.openManual();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        boolean textField = false;
        this.pageButtons.clear();
        if (this.currentNode.isLeaf()) {
            this.currentNode.getLeafData().addButtons(this, this.guiLeft + 32, this.guiTop + 28, this.page, this.pageButtons);
            for (Button b : this.pageButtons) {
                this.addButton((Widget)b);
            }
        } else {
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> children = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            for (Tree.AbstractNode<ResourceLocation, ManualEntry> node : this.currentNode.getChildren()) {
                if (!this.manual.showNodeInList(node)) continue;
                children.add(node);
            }
            Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> openEntry = sel -> {
                if (sel != null) {
                    this.previousSelectedEntry.clear();
                    this.setCurrentNode((Tree.AbstractNode<ResourceLocation, ManualEntry>)sel);
                    this.fullInit();
                }
            };
            this.entryList = new ClickableList(this, this.guiLeft + 40, this.guiTop + 20, 100, 168, 1.0f, children, openEntry);
            this.addButton((Widget)this.entryList);
            this.suggestionList = new ClickableList(this, this.guiLeft + 180, this.guiTop + 138, 100, 80, 1.0f, new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>(), openEntry);
            this.suggestionList.visible = false;
            this.addButton((Widget)this.suggestionList);
            textField = true;
        }
        if (this.currentNode.getSuperNode() != null) {
            this.addButton((Widget)new GuiButtonManualNavigation(this, this.guiLeft + 24, this.guiTop + 10, 10, 10, 0, btn -> {
                if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                    this.previousSelectedEntry.pop().changePage(this, false);
                } else if (this.currentNode.getSuperNode() != null) {
                    this.setCurrentNode(this.currentNode.getSuperNode());
                }
                this.page = 0;
                this.fullInit();
            }));
        }
        if (textField) {
            this.mc.field_195559_v.func_197967_a(true);
            this.searchField = new TextFieldWidget(this.font, this.guiLeft + 166, this.guiTop + 78, 120, 12, "");
            this.searchField.func_146193_g(-1);
            this.searchField.func_146204_h(-1);
            this.searchField.func_146185_a(false);
            this.searchField.func_146203_f(17);
            this.searchField.func_146195_b(true);
            this.searchField.func_146205_d(false);
        } else if (this.searchField != null) {
            this.searchField = null;
        }
        if (this.setLastActive) {
            lastActiveManual = this;
        }
    }

    public void fullInit() {
        super.init(this.minecraft, this.width, this.height);
    }

    public void render(int mouseX, int mouseY, float f) {
        ++this.manualTick;
        this.manual.entryRenderPre();
        ManualUtils.bindTexture(this.texture);
        this.blit(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.searchField != null) {
            int l = this.searchField.func_146179_b().length() * 6;
            if (l > 20) {
                this.blit(this.guiLeft + 166, this.guiTop + 74, 136 + (120 - l), 238, l, 18);
            }
            if (this.suggestionList.visible) {
                this.blit(this.guiLeft + 174, this.guiTop + 100, 214, 212, 16, 26);
                int h = this.suggestionList.getHeight();
                int w = 76;
                this.blit(this.guiLeft + 174, this.guiTop + 116, 230, 212, 16, 16);
                this.blit(this.guiLeft + 174, this.guiTop + 132 + h, 230, 228, 16, 10);
                this.blit(this.guiLeft + 190 + w, this.guiTop + 116, 246, 212, 10, 16);
                this.blit(this.guiLeft + 190 + w, this.guiTop + 132 + h, 246, 228, 10, 10);
                for (int hh = 0; hh < h; ++hh) {
                    this.blit(this.guiLeft + 174, this.guiTop + 132 + hh, 230, 228, 16, 1);
                    for (int ww = 0; ww < w; ++ww) {
                        this.blit(this.guiLeft + 190 + ww, this.guiTop + 132 + hh, 246, 228, 1, 1);
                    }
                    this.blit(this.guiLeft + 190 + w, this.guiTop + 132 + hh, 246, 228, 10, 1);
                }
                for (int ww = 0; ww < w; ++ww) {
                    this.blit(this.guiLeft + 190 + ww, this.guiTop + 116, 246, 212, 1, 16);
                    this.blit(this.guiLeft + 190 + ww, this.guiTop + 132 + h, 246, 228, 1, 10);
                }
            }
        }
        if (this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            boolean b0 = (mouseX -= this.guiLeft) > 32 && mouseX < 49 && (mouseY -= this.guiTop) > 179 && mouseY < 189;
            boolean b1 = mouseX > 135 && mouseX < 152 && mouseY > 179 && mouseY < 189;
            RenderSystem.enableBlend();
            if (this.page > 0) {
                this.blit(this.guiLeft + 32, this.guiTop + 179, 0, 216 + (b0 ? 20 : 0), 16, 10);
            }
            if (this.page < selectedEntry.getPageCount() - 1) {
                this.blit(this.guiLeft + 136, this.guiTop + 179, 0, 226 + (b1 ? 20 : 0), 16, 10);
            }
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(this.manual.fontRenderer(), TextFormatting.BOLD + selectedEntry.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop + 14, this.manual.getTitleColour(), 1.0f, true);
            this.drawCenteredStringScaled(this.manual.fontRenderer(), this.manual.formatEntrySubtext(selectedEntry.getSubtext()), this.guiLeft + this.xSize / 2, this.guiTop + 22, this.manual.getSubTitleColour(), 1.0f, true);
            this.drawCenteredStringScaled(this.manual.fontRenderer(), TextFormatting.BOLD.toString() + (this.page + 1), this.guiLeft + this.xSize / 2, this.guiTop + 183, this.manual.getPagenumberColour(), 1.0f, false);
            this.manual.titleRenderPost();
            selectedEntry.renderPage(this, this.guiLeft + 32, this.guiTop + 28, mouseX - 32, mouseY - 28);
            mouseX += this.guiLeft;
            mouseY += this.guiTop;
        } else {
            String title = ManualUtils.getTitleForNode(this.currentNode, this.manual);
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(this.manual.fontRenderer(), TextFormatting.BOLD + title, this.guiLeft + this.xSize / 2, this.guiTop + 12, this.manual.getTitleColour(), 1.0f, true);
            this.manual.titleRenderPost();
        }
        if (this.searchField != null) {
            this.searchField.render(mouseX, mouseY, f);
            if (this.suggestionList.visible) {
                this.manual.fontRenderer().func_211126_b("It looks like you meant:", (float)(this.guiLeft + 180), (float)(this.guiTop + 128), this.manual.getTextColour());
            }
        }
        for (Button btn : this.pageButtons) {
            btn.render(mouseX, mouseY, f);
        }
        super.render(mouseX, mouseY, f);
        RenderSystem.enableBlend();
        this.manual.entryRenderPost();
    }

    public void onClose() {
        this.manual.closeManual();
        super.onClose();
        if (this.prevGuiScale != -1 && this.manual.allowGuiRescale()) {
            this.mc.field_71474_y.field_74335_Z = this.prevGuiScale;
        }
    }

    private void drawCenteredStringScaled(FontRenderer fr, String s, int x, int y, int colour, float scale, boolean shadow) {
        int xx = (int)Math.floor((double)((float)x / scale) - (double)fr.func_78256_a(s) / 2.0);
        double d = (float)y / scale;
        fr.getClass();
        int yy = (int)Math.floor(d - 9.0 / 2.0);
        if (scale != 1.0f) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        }
        if (shadow) {
            fr.func_175063_a(s, (float)xx, (float)yy, colour);
        } else {
            fr.func_211126_b(s, (float)xx, (float)yy, colour);
        }
        if (scale != 1.0f) {
            RenderSystem.popMatrix();
        }
    }

    public List<String> getTooltipFromItem(ItemStack stack) {
        ManualInstance.ManualLink link;
        List tooltip = super.getTooltipFromItem(stack);
        if (this.currentNode.isLeaf() && this.currentNode.getLeafData().getHighlightedStack(this.page) == stack && (link = this.manual.getManualLink(stack)) != null) {
            tooltip.add(this.manual.formatLink(link));
        }
        return tooltip;
    }

    public void renderTooltip(List<String> text, int x, int y, FontRenderer font) {
        this.manual.tooltipRenderPre();
        super.renderTooltip(text, x, y, font);
        this.manual.tooltipRenderPost();
    }

    public boolean mouseScrolled(double x, double y, double wheel) {
        super.mouseScrolled(x, y, wheel);
        if (wheel != 0.0 && this.currentNode.isLeaf()) {
            if (wheel > 0.0 && this.page > 0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (wheel < 0.0 && this.page < this.currentNode.getLeafData().getPageCount() - 1) {
                ++this.page;
                this.fullInit();
                return true;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0 && this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            double mxRelative = mx - (double)this.guiLeft;
            double myRelative = my - (double)this.guiTop;
            if (this.page > 0 && mxRelative > 32.0 && mxRelative < 49.0 && myRelative > 179.0 && myRelative < 189.0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (this.page < selectedEntry.getPageCount() - 1 && mxRelative > 135.0 && mxRelative < 152.0 && myRelative > 179.0 && myRelative < 189.0) {
                ++this.page;
                this.fullInit();
                return true;
            }
            ItemStack highlighted = selectedEntry.getHighlightedStack(this.page);
            if (!highlighted.func_190926_b()) {
                ManualInstance.ManualLink link = this.getManual().getManualLink(highlighted);
                if (link != null) {
                    link.changePage(this, true);
                }
                return true;
            }
        } else if (button == 1) {
            if (this.searchField != null && !this.searchField.func_146179_b().isEmpty()) {
                this.searchField.func_146180_a("");
            } else if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                this.previousSelectedEntry.pop().changePage(this, false);
            } else if (this.currentNode.getSuperNode() != null) {
                IELogger.logger.info("Changing to super node {}", this.currentNode.getSuperNode());
                this.setCurrentNode(this.currentNode.getSuperNode());
                this.page = 0;
            }
            this.fullInit();
            return true;
        }
        this.lastClick = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
        if (super.mouseClicked(mx, my, button)) {
            return true;
        }
        if (this.searchField != null) {
            this.searchField.mouseClicked(mx, my, button);
        }
        return false;
    }

    public boolean mouseReleased(double mx, double my, int action) {
        this.lastClick = null;
        this.lastDrag = null;
        return super.mouseReleased(mx, my, action);
    }

    public boolean mouseDragged(double mx, double my, int button, double deltaX, double deltaY) {
        if (this.lastClick != null && this.currentNode.isLeaf()) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            }
            this.currentNode.getLeafData().mouseDragged(this, this.guiLeft + 32, this.guiTop + 28, this.lastClick[0], this.lastClick[1], mx - (double)this.guiLeft, my - (double)this.guiTop, this.lastDrag[0], this.lastDrag[1], button);
            this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            return true;
        }
        return false;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField != null && this.searchField.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            this.updateSearch();
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.searchField != null && this.searchField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            this.updateSearch();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private void updateSearch() {
        String search = this.searchField.func_146179_b();
        if (search.trim().isEmpty()) {
            this.suggestionList.visible = false;
            this.fullInit();
        } else {
            search = search.toLowerCase(Locale.ENGLISH);
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> lHeaders = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            HashSet lSpellcheck = new HashSet();
            String searchFinal = search;
            this.manual.getAllEntriesAndCategories().forEach(node -> {
                if (this.manual.showNodeInList((Tree.AbstractNode<ResourceLocation, ManualEntry>)node)) {
                    String title = ManualUtils.getTitleForNode(node, this.manual).toLowerCase(Locale.ENGLISH);
                    if (title.contains(searchFinal)) {
                        lHeaders.add((Tree.AbstractNode<ResourceLocation, ManualEntry>)node);
                    } else {
                        lSpellcheck.add(node);
                    }
                }
            });
            List<Tree.AbstractNode<ResourceLocation, ManualEntry>> lCorrections = ManualUtils.getPrimitiveSpellingCorrections(search, lSpellcheck, 4, e -> ManualUtils.getTitleForNode(e, this.manual));
            for (Tree.AbstractNode node2 : lSpellcheck) {
                if (lCorrections.contains(node2) || !node2.isLeaf() || !((ManualEntry)node2.getLeafData()).listForSearch(search)) continue;
                lHeaders.add(node2);
                lCorrections.add(node2);
                break;
            }
            this.entryList.setEntries(lHeaders);
            if (!lCorrections.isEmpty()) {
                this.suggestionList.setEntries(lCorrections);
            }
            this.suggestionList.visible = !lCorrections.isEmpty();
        }
    }

    public void fillGradient(int x1, int yA, int x2, int yB, int colorA, int colorB) {
        super.fillGradient(x1, yA, x2, yB, colorA, colorB);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

