/*
 * Decompiled with CFR 0.152.
 */
package third_party.com.facebook.yoga;

import com.google.common.base.Objects;
import java.util.Arrays;
import third_party.com.facebook.yoga.ArrayUtil;
import third_party.com.facebook.yoga.YogaCachedMeasurement;
import third_party.com.facebook.yoga.YogaDirection;

public final class YogaLayout {
    public static final int MaxCachedResultCount = 8;
    public final float[] Position = new float[4];
    public final float[] Dimensions = new float[]{Float.NaN, Float.NaN};
    public final float[] Margin = new float[6];
    public final float[] Border = new float[6];
    public final float[] Padding = new float[6];
    public YogaDirection Direction;
    public int ComputedFlexBasisGeneration;
    public float ComputedFlexBasis;
    public boolean HadOverflow;
    public int GenerationCount;
    public YogaDirection LastOwnerDirection;
    public int NextCachedMeasurementsIndex;
    public YogaCachedMeasurement[] CachedMeasurements;
    public final float[] MeasuredDimensions = new float[]{Float.NaN, Float.NaN};
    public YogaCachedMeasurement CachedLayout;
    public boolean DidUseLegacyFlag;
    public boolean DoesLegacyStretchFlagAffectsLayout;

    public YogaLayout() {
        YogaCachedMeasurement[] cached = new YogaCachedMeasurement[8];
        for (int i = 0; i < cached.length; ++i) {
            cached[i] = new YogaCachedMeasurement();
        }
        this.Direction = YogaDirection.Inherit;
        this.ComputedFlexBasisGeneration = 0;
        this.ComputedFlexBasis = Float.NaN;
        this.HadOverflow = false;
        this.GenerationCount = 0;
        this.NextCachedMeasurementsIndex = 0;
        this.CachedMeasurements = cached;
        this.CachedLayout = new YogaCachedMeasurement();
        this.DidUseLegacyFlag = false;
        this.DoesLegacyStretchFlagAffectsLayout = false;
    }

    public static boolean Equal(YogaLayout self, YogaLayout layout) {
        if (self == layout) {
            return true;
        }
        if (self == null || layout == null) {
            return false;
        }
        boolean isEqual = Arrays.equals(self.Position, layout.Position) && Arrays.equals(self.Dimensions, layout.Dimensions) && Arrays.equals(self.Margin, layout.Margin) && Arrays.equals(self.Border, layout.Border) && Arrays.equals(self.Padding, layout.Padding) && self.Direction == layout.Direction && self.HadOverflow == layout.HadOverflow && self.LastOwnerDirection == layout.LastOwnerDirection && self.NextCachedMeasurementsIndex == layout.NextCachedMeasurementsIndex && self.CachedLayout == layout.CachedLayout;
        for (int i = 0; i < 8 && isEqual; ++i) {
            isEqual = isEqual && self.CachedMeasurements[i] == layout.CachedMeasurements[i];
        }
        isEqual = isEqual && self.ComputedFlexBasis == layout.ComputedFlexBasis;
        isEqual = isEqual && self.MeasuredDimensions[0] == layout.MeasuredDimensions[0];
        isEqual = isEqual && self.MeasuredDimensions[1] == layout.MeasuredDimensions[1];
        return isEqual;
    }

    public void CopyFrom(YogaLayout other) {
        ArrayUtil.copy(other.Position, this.Position);
        ArrayUtil.copy(other.Dimensions, this.Dimensions);
        ArrayUtil.copy(other.Margin, this.Margin);
        ArrayUtil.copy(other.Border, this.Border);
        ArrayUtil.copy(other.Padding, this.Padding);
        this.Direction = other.Direction;
        this.ComputedFlexBasisGeneration = other.ComputedFlexBasisGeneration;
        this.ComputedFlexBasis = other.ComputedFlexBasis;
        this.HadOverflow = other.HadOverflow;
        this.GenerationCount = other.GenerationCount;
        this.LastOwnerDirection = other.LastOwnerDirection;
        this.NextCachedMeasurementsIndex = other.NextCachedMeasurementsIndex;
        this.CachedMeasurements = Arrays.copyOf(other.CachedMeasurements, this.CachedMeasurements.length);
        ArrayUtil.copy(other.MeasuredDimensions, this.MeasuredDimensions);
        this.CachedLayout.CopyFrom(other.CachedLayout);
        this.DidUseLegacyFlag = other.DidUseLegacyFlag;
        this.DoesLegacyStretchFlagAffectsLayout = other.DoesLegacyStretchFlagAffectsLayout;
    }

    public void Clear() {
        Arrays.fill(this.Position, 0.0f);
        Arrays.fill(this.Dimensions, 0.0f);
        Arrays.fill(this.Margin, 0.0f);
        Arrays.fill(this.Border, 0.0f);
        Arrays.fill(this.Padding, 0.0f);
        this.Direction = YogaDirection.Inherit;
        this.ComputedFlexBasisGeneration = 0;
        this.ComputedFlexBasis = 0.0f;
        this.HadOverflow = false;
        this.GenerationCount = 0;
        this.LastOwnerDirection = YogaDirection.Inherit;
        this.NextCachedMeasurementsIndex = 0;
        Arrays.fill(this.MeasuredDimensions, 0.0f);
        this.CachedLayout.Clear();
        this.DidUseLegacyFlag = false;
        this.DoesLegacyStretchFlagAffectsLayout = false;
        for (YogaCachedMeasurement item : this.CachedMeasurements) {
            item.Clear();
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.Position, this.Dimensions, this.Margin, this.Border, this.Padding, this.Direction, this.ComputedFlexBasisGeneration, Float.valueOf(this.ComputedFlexBasis), this.HadOverflow, this.GenerationCount, this.LastOwnerDirection, this.NextCachedMeasurementsIndex, this.CachedMeasurements, this.MeasuredDimensions, this.CachedLayout, this.DidUseLegacyFlag, this.DoesLegacyStretchFlagAffectsLayout});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != YogaLayout.class) {
            return false;
        }
        return YogaLayout.Equal(this, (YogaLayout)obj);
    }
}

