/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.gui.GuiConfigHome;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.WailaTickHandler;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.extensions.IForgeKeybinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
public class WailaClient {
    public static IForgeKeybinding openConfig;
    public static IForgeKeybinding showOverlay;
    public static IForgeKeybinding toggleLiquid;

    public static void initClient() {
        openConfig = new KeyBinding("key.waila.config", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM.func_197944_a(320), "Waila");
        showOverlay = new KeyBinding("key.waila.show_overlay", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM.func_197944_a(321), "Waila");
        toggleLiquid = new KeyBinding("key.waila.toggle_liquid", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM.func_197944_a(322), "Waila");
        ClientRegistry.registerKeyBinding((KeyBinding)openConfig.getKeyBinding());
        ClientRegistry.registerKeyBinding((KeyBinding)showOverlay.getKeyBinding());
        ClientRegistry.registerKeyBinding((KeyBinding)toggleLiquid.getKeyBinding());
        ModList.get().getModContainerById("waila").ifPresent(c -> c.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, parent) -> new GuiConfigHome((Screen)parent)));
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (openConfig == null || showOverlay == null || toggleLiquid == null) {
            return;
        }
        while (openConfig.getKeyBinding().func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiConfigHome(null));
        }
        while (showOverlay.getKeyBinding().func_151468_f()) {
            if (Waila.CONFIG.get().getGeneral().getDisplayMode() != WailaConfig.DisplayMode.TOGGLE) continue;
            Waila.CONFIG.get().getGeneral().setDisplayTooltip(!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip());
        }
        while (toggleLiquid.getKeyBinding().func_151468_f()) {
            Waila.CONFIG.get().getGeneral().setDisplayFluids(!Waila.CONFIG.get().getGeneral().shouldDisplayFluids());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTooltip(ItemTooltipEvent event) {
        String name = String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModInfo(event.getItemStack()).getName());
        event.getToolTip().add(new StringTextComponent(name));
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WailaTickHandler.instance().tickClient();
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field _sortedList = ModList.class.getDeclaredField("sortedList");
            _sortedList.setAccessible(true);
            MethodHandle _getSortedList = lookup.unreflectGetter(_sortedList);
            List sortedList = _getSortedList.invokeExact(ModList.get());
            ModInfo wailaInfo = sortedList.stream().filter(modInfo -> modInfo.getModId().equals("waila")).findFirst().get();
            WailaModInfo modInfo2 = new WailaModInfo(wailaInfo);
            sortedList.set(sortedList.indexOf(wailaInfo), new WailaModInfo(wailaInfo));
            ModContainer wailaContainer = (ModContainer)ModList.get().getModContainerById("waila").get();
            Field _modInfo = ModContainer.class.getDeclaredField("modInfo");
            _modInfo.setAccessible(true);
            MethodHandle _setModInfo = lookup.unreflectSetter(_modInfo);
            _setModInfo.invokeExact(wailaContainer, (IModInfo)modInfo2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Waila.LOGGER.error("Failed to replace ModInfo instance with one that supports the mod list config");
        }
    }

    private static class WailaModInfo
    extends ModInfo {
        public WailaModInfo(ModInfo modInfo) {
            super(modInfo.getOwningFile(), modInfo.getModConfig());
        }

        public boolean hasConfigUI() {
            return true;
        }
    }
}

