/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public class CommandTBKnownledge
extends TombstoneCommand {
    public CommandTBKnownledge(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbknowledge";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.showUsage((CommandSource)c.getSource()));
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.showKnowledge((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player")))).then(SubCommand.SHOW.literal().executes(c -> this.showKnowledge((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"))))).then(((LiteralArgumentBuilder)SubCommand.SET.literal().executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(c -> this.setKnowledge((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), IntegerArgumentType.getInteger((CommandContext)c, (String)"amount")))))).then(((LiteralArgumentBuilder)SubCommand.GIVE.literal().executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(c -> this.giveKnowledge((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), IntegerArgumentType.getInteger((CommandContext)c, (String)"amount")))))).then(((LiteralArgumentBuilder)SubCommand.REMOVE.literal().executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(c -> this.removeKnowledge((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), IntegerArgumentType.getInteger((CommandContext)c, (String)"amount"))))));
        return builder;
    }

    private int showKnowledge(CommandSource sender, ServerPlayerEntity target) {
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> this.sendMessage(sender, LangKey.MESSAGE_SHOW_KNOWLEDGE.getTranslationWithStyle(StyleType.MESSAGE_SPELL, target.func_200200_C_(), cap.getKnowledge()), false));
        return 1;
    }

    private int setKnowledge(CommandSource sender, ServerPlayerEntity target, long newKnowledge) {
        if (newKnowledge < 0L) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        int adjust = (int)(newKnowledge - EntityHelper.getKnowledge((PlayerEntity)target));
        if (adjust >= 0) {
            this.giveKnowledge(sender, target, adjust);
        } else {
            this.removeKnowledge(sender, target, -adjust);
        }
        return 1;
    }

    private int giveKnowledge(CommandSource sender, ServerPlayerEntity target, int amount) {
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        EntityHelper.addKnowledge(target, amount);
        if (!target.equals((Object)sender.func_197022_f()) || !DeathHandler.INSTANCE.getOptionKnowledgeMessage(target.func_110124_au())) {
            this.sendMessage(sender, LangKey.MESSAGE_EARN_KNOWLEDGE.getTranslation(LangKey.MESSAGE_PLAYER_KNOWLEDGE.getTranslation(target.func_200200_C_()), amount), false);
        }
        return 1;
    }

    private int removeKnowledge(CommandSource sender, ServerPlayerEntity target, int amount) {
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        EntityHelper.removeKnowledge(target, amount);
        if (!target.equals((Object)sender.func_197022_f()) || !DeathHandler.INSTANCE.getOptionKnowledgeMessage(target.func_110124_au())) {
            this.sendMessage(sender, LangKey.MESSAGE_LOSE_KNOWLEDGE.getTranslationWithStyle(StyleType.MESSAGE_SPELL, LangKey.MESSAGE_PLAYER_KNOWLEDGE.getTranslation(target.func_200200_C_()), amount), false);
        }
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        SHOW,
        SET,
        GIVE,
        REMOVE;

    }
}

