/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer {
    private static final String POPPET_PROT_PREFIX = "poppet_prot_";

    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder(true), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getTranslation(name) : name).func_150255_a(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            boolean hasProt = false;
            for (PoppetProtections prot : PoppetProtections.values()) {
                if (!this.hasProtection(stack, prot)) continue;
                list.add(LangKey.makeTranslationWithStyle(StyleType.TOOLTIP_ITEM, this.func_77658_a() + "." + prot.getName(), new Object[0]));
                hasProt = true;
            }
            this.addItemUse(list, this.isEnchanted(stack) ? "3" : (hasProt ? "2" : "1"), new Object[0]);
            if (EntityHelper.getPerkLevelWithBonus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModPerks.voodoo_poppet) <= 0) {
                this.addWarn(list, LangKey.MESSAGE_PERK_REQUIRED, LangKey.makeTranslationWithStyle(StyleType.TOOLTIP_ITEM, ModPerks.voodoo_poppet.getTranslationKey(), new Object[0]));
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_NO_PROTECTION_TO_SEAL.getTranslation(new Object[0]);
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (!this.isEnchanted(stack) && Arrays.stream(PoppetProtections.values()).anyMatch(p -> this.hasProtection(stack, (PoppetProtections)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return true;
        }
        return false;
    }

    public ItemStack addProtection(ItemStack stack, PoppetProtections prot) {
        if (stack.func_77973_b() == this && !this.isEnchanted(stack) && !this.hasProtection(stack, prot)) {
            NBTStackHelper.setBoolean(stack, POPPET_PROT_PREFIX + prot.ordinal(), true);
        }
        return stack;
    }

    public boolean hasProtection(ItemStack stack, PoppetProtections prot) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + prot.ordinal());
    }

    private boolean removeProtection(ItemStack stack, PoppetProtections prot) {
        return NBTStackHelper.removeKeyName(stack, POPPET_PROT_PREFIX + prot.ordinal());
    }

    public boolean preventDeath(PlayerEntity player, ItemStack stack, PoppetProtections prot) {
        if (this.canPreventDeath(stack, prot) && this.removeProtection(stack, prot)) {
            NBTStackHelper.setBoolean(stack, "enchant", false);
            int duration = TimeHelper.tickFromSecond((Integer)ConfigTombstone.decorative_grave.durationVoodooPoppetEffects.get());
            switch (prot) {
                case SUFFOCATION: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76427_o, duration);
                    break;
                }
                case BURN: {
                    player.func_70066_B();
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76426_n, duration);
                    break;
                }
                case LIGHTNING: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, ModEffects.lightning_resistance, duration);
                    break;
                }
                case FALL: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, ModEffects.feather_fall, duration);
                    break;
                }
                case DEGENERATION: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76443_y, duration);
                    EffectHelper.clearBadEffects((LivingEntity)player);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean canPreventDeath(ItemStack stack, PoppetProtections prot) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + prot.ordinal());
    }

    @Nullable
    public PoppetProtections getPoppetProtections(DamageSource srcDmg) {
        return Arrays.stream(PoppetProtections.values()).filter(p -> ((PoppetProtections)p).preventDmg.test(srcDmg)).findFirst().orElse(null);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }

    public static enum PoppetProtections {
        SUFFOCATION(LangKey.MESSAGE_PREVENT_DEATH_SUFFOCATION, p -> p == DamageSource.field_76369_e || p == DamageSource.field_76368_d || p == DamageSource.field_191291_g),
        BURN(LangKey.MESSAGE_PREVENT_DEATH_BURN, DamageSource::func_76347_k),
        LIGHTNING(LangKey.MESSAGE_PREVENT_DEATH_LIGHTNING, p -> p == DamageSource.field_180137_b),
        FALL(LangKey.MESSAGE_PREVENT_DEATH_FALL, p -> p == DamageSource.field_76379_h || p == DamageSource.field_188406_j),
        DEGENERATION(LangKey.MESSAGE_PREVENT_DEATH_DEGENERATION, p -> p == DamageSource.field_82727_n || p == DamageSource.field_76366_f || p == ModDamages.BEYOND_THE_GRAVE);

        private final LangKey key;
        private final Predicate<DamageSource> preventDmg;

        private PoppetProtections(LangKey key, Predicate<DamageSource> preventDmg) {
            this.key = key;
            this.preventDmg = preventDmg;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public LangKey getLangKey() {
            return this.key;
        }

        public static PoppetProtections getRandomProtection() {
            return PoppetProtections.values()[Helper.getRandom(0, PoppetProtections.values().length - 1)];
        }
    }
}

