/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.TransparentParticle;
import ovh.corail.tombstone.registry.ModSounds;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGhost
extends TransparentParticle {
    private final IAnimatedSprite spriteSet;
    private final double mX;
    private final double mZ;

    private ParticleGhost(IAnimatedSprite spriteSet, World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y + 1.0, z);
        this.mX = motionX;
        this.mZ = motionZ;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.func_187114_a(200);
        this.field_190017_n = false;
        this.func_70541_f(8.0f);
        this.func_70538_b(1.0f, 1.0f, 1.0f);
        ((ClientWorld)world).func_217410_a(new LightningBoltEntity(world, x, y, z, true));
        world.func_184134_a(x, y, z, Helper.getRandom(0, 3) == 0 ? ModSounds.GHOST_LAUGH : ModSounds.GHOST_HOWL, SoundCategory.VOICE, 1.0f, 1.0f, true);
        this.spriteSet = spriteSet;
        this.func_217566_b(this.spriteSet);
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.func_187113_k()) {
            if (this.field_70546_d == 10) {
                this.field_187129_i = this.mX;
                this.field_187131_k = this.mZ;
            }
            float ratio = (float)this.field_70546_d / (float)this.field_70547_e;
            this.func_82338_g((1.0f - ratio) * 0.8f);
            ModTombstone.PROXY.produceGraveSmoke(this.field_187122_b, this.field_187126_f, this.field_187127_g - 1.0, this.field_187128_h);
            this.func_217566_b(this.spriteSet);
        }
    }

    protected int func_189214_a(float partialTick) {
        int skylight = 15;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType type, World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ParticleGhost(this.spriteSet, world, x, y, z, Helper.getRandom(-0.05, 0.05), 0.0, Helper.getRandom(-0.05, 0.05));
        }
    }
}

