/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import nomadictents.block.BlockTentDoor;
import nomadictents.block.BlockUnbreakable;
import nomadictents.block.Categories;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.init.Content;
import nomadictents.init.TentConfig;

public class BlockTepeeWall
extends BlockUnbreakable
implements Categories.ITepeeBlock {
    public BlockTepeeWall(String name, boolean cosmetic) {
        super(Block.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151658_d).func_208770_d(), cosmetic);
        this.setRegistryName("nomadictents", name);
    }

    public void func_220082_b(BlockState stateIn, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(stateIn, worldIn, pos, oldState, isMoving);
        if (stateIn.func_177230_c() == Content.TEPEE_WALL_BLANK) {
            BlockPos doorPos = BlockTepeeWall.traceToDoorNearby(worldIn, pos);
            BlockState state = BlockTepeeWall.getStateForRandomDesignWithChance(worldIn.field_73012_v, true);
            if (!TentDimensionManager.isTent((IWorld)worldIn) && doorPos != null && Math.abs(pos.func_177956_o() - doorPos.func_177956_o()) % 2 == 0 && worldIn.func_175625_s(doorPos) instanceof TileEntityTentDoor) {
                TileEntityTentDoor te = (TileEntityTentDoor)worldIn.func_175625_s(doorPos);
                int id = (int)te.getTentData().getID();
                int randSeed = pos.func_177956_o() + doorPos.func_177958_n() + doorPos.func_177952_p() + id * 123 + te.getTentData().getWidth().getId() * 101;
                state = BlockTepeeWall.getStateForRandomPattern(new Random(randSeed), true);
            }
            if (state != null) {
                worldIn.func_180501_a(pos, state, 2);
            }
        }
    }

    public static BlockState getStateForBase(boolean indestructible) {
        return indestructible ? Content.TEPEE_WALL_BLANK.func_176223_P() : Content.COS_TEPEE_WALL_BLANK.func_176223_P();
    }

    public static BlockState getStateForRandomPattern(Random rand, boolean indestructible) {
        Block[] PATTERNS_INDEST = new Block[]{Content.TEPEE_WALL_BLACK, Content.TEPEE_WALL_ORANGE, Content.TEPEE_WALL_RED, Content.TEPEE_WALL_WHITE, Content.TEPEE_WALL_YELLOW};
        Block[] PATTERNS_COSM = new Block[]{Content.COS_TEPEE_WALL_BLACK, Content.COS_TEPEE_WALL_ORANGE, Content.COS_TEPEE_WALL_RED, Content.COS_TEPEE_WALL_WHITE, Content.COS_TEPEE_WALL_YELLOW};
        int index = rand.nextInt(PATTERNS_INDEST.length);
        return indestructible ? PATTERNS_INDEST[index].func_176223_P() : PATTERNS_COSM[index].func_176223_P();
    }

    public static BlockState getStateForRandomDesignWithChance(Random rand, boolean indestructible) {
        return rand.nextInt(100) < (Integer)TentConfig.CONFIG.TEPEE_DECORATED_CHANCE.get() ? BlockTepeeWall.getStateForRandomDesign(rand, indestructible) : BlockTepeeWall.getStateForBase(indestructible);
    }

    public static BlockState getStateForRandomDesign(Random rand, boolean indestructible) {
        Block[] TEXTURES_INDEST = new Block[]{Content.TEPEE_WALL_CREEPER, Content.TEPEE_WALL_DREAMCATCHER, Content.TEPEE_WALL_EAGLE, Content.TEPEE_WALL_HOPE, Content.TEPEE_WALL_MAGIC, Content.TEPEE_WALL_RAIN, Content.TEPEE_WALL_SUN, Content.TEPEE_WALL_TRIFORCE, Content.TEPEE_WALL_UNIVERSE};
        Block[] TEXTURES_COSM = new Block[]{Content.COS_TEPEE_WALL_CREEPER, Content.COS_TEPEE_WALL_DREAMCATCHER, Content.COS_TEPEE_WALL_EAGLE, Content.COS_TEPEE_WALL_HOPE, Content.COS_TEPEE_WALL_MAGIC, Content.COS_TEPEE_WALL_RAIN, Content.COS_TEPEE_WALL_SUN, Content.COS_TEPEE_WALL_TRIFORCE, Content.COS_TEPEE_WALL_UNIVERSE};
        int index = rand.nextInt(TEXTURES_INDEST.length);
        return indestructible ? TEXTURES_INDEST[index].func_176223_P() : TEXTURES_COSM[index].func_176223_P();
    }

    private static BlockPos traceToDoorNearby(World world, BlockPos pos) {
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        while (pos != null && !(world.func_180495_p(pos).func_177230_c() instanceof BlockTentDoor)) {
            pos = BlockTepeeWall.traceNextTepeeBlock(world, checked, pos);
        }
        if (pos == null) {
            return null;
        }
        boolean isLower = world.func_180495_p(pos).func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER;
        return isLower ? pos : pos.func_177979_c(1);
    }

    private static BlockPos traceNextTepeeBlock(World worldIn, Set<BlockPos> exclude, BlockPos pos) {
        int radius = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    BlockState stateAt = worldIn.func_180495_p(checkPos);
                    if (exclude.contains(checkPos) || !(stateAt.func_177230_c() instanceof Categories.ITepeeBlock) && !(stateAt.func_177230_c() instanceof Categories.IFrameBlock)) continue;
                    exclude.add(checkPos);
                    return checkPos;
                }
            }
        }
        return null;
    }
}

