/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import nomadictents.init.Content;
import nomadictents.item.ItemTent;
import nomadictents.structure.util.TentData;
import nomadictents.structure.util.TentDepth;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public class RecipeUpgradeWidth
extends ShapedRecipe {
    public static final String CATEGORY = "tent_upgrade_width";
    public static final RecipeUpgradeWidth EMPTY = new RecipeUpgradeWidth();
    private final TentType tent;
    private final TentWidth widthIn;
    private final TentWidth widthOut;

    public RecipeUpgradeWidth(ResourceLocation id, TentType type, @Nullable TentWidth widthFrom, TentWidth widthTo, NonNullList<Ingredient> ingredients) {
        super(id, CATEGORY, 3, RecipeUpgradeWidth.calcRecipeHeight(type, widthTo), ingredients, new TentData().setAll(type, widthTo, TentDepth.NORMAL).getDropStack());
        this.tent = type;
        this.widthIn = widthFrom;
        this.widthOut = widthTo;
    }

    private RecipeUpgradeWidth() {
        super(new ResourceLocation("empty"), CATEGORY, 3, 3, NonNullList.func_191196_a(), ItemStack.field_190927_a);
        this.tent = TentType.YURT;
        this.widthIn = TentWidth.SMALL;
        this.widthOut = TentWidth.SMALL;
    }

    private static int calcRecipeHeight(TentType type, TentWidth widthTo) {
        if (type == TentType.YURT || type == TentType.SHAMIANA && widthTo.getId() < TentWidth.HUGE.getId()) {
            return 2;
        }
        return 3;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (this != EMPTY && this.tent.isEnabled() && super.func_77569_a(inv, worldIn)) {
            TentData data;
            if (this.widthOut == TentWidth.SMALL) {
                return true;
            }
            ItemStack tentStack = RecipeUpgradeWidth.getTentStack(inv);
            if (!tentStack.func_190926_b() && (data = new TentData(tentStack)).getTent() == this.tent && data.getWidth() == this.widthIn && this.widthOut.getId() < data.getTent().getMaxSize()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        if (this == EMPTY || !this.tent.isEnabled()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = super.func_77572_b(inv);
        CompoundNBT resultTag = result.func_196082_o();
        ItemStack inputTent = RecipeUpgradeWidth.getTentStack(inv);
        if (!inputTent.func_190926_b() && inputTent.func_77942_o()) {
            TentData tentData = new TentData(inputTent);
            tentData.setWidth(this.widthOut);
            resultTag.func_218657_a("TentData", (INBT)tentData.serializeNBT());
        } else {
            TentData data = new TentData().setAll(this.tent, this.widthOut, TentDepth.NORMAL);
            resultTag.func_218657_a("TentData", (INBT)data.serializeNBT());
        }
        result.func_77982_d(resultTag);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Content.SERIALIZER_WIDTH;
    }

    public TentType getTent() {
        return this.tent;
    }

    public TentWidth getWidthIn() {
        return this.widthIn;
    }

    public TentWidth getWidthOut() {
        return this.widthOut;
    }

    public static ItemStack getStackMatching(CraftingInventory inv, Class<? extends Item> itemClass) {
        int l = inv.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() == null || !itemClass.isAssignableFrom(stack.func_77973_b().getClass())) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getTentStack(CraftingInventory inv) {
        return RecipeUpgradeWidth.getStackMatching(inv, ItemTent.class);
    }

    public static class Factory
    extends ShapedRecipe.Serializer {
        public ShapedRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            if (json.has("disabled")) {
                return EMPTY;
            }
            ShapedRecipe recipe = super.func_199425_a_(recipeId, json);
            TentType tentType = TentType.getByName(JSONUtils.func_151200_h((JsonObject)json, (String)"tent_type"));
            TentWidth widthIn = TentWidth.getByName(JSONUtils.func_151200_h((JsonObject)json, (String)"input_size"));
            TentWidth widthOut = TentWidth.getByName(JSONUtils.func_151200_h((JsonObject)json, (String)"result_size"));
            return new RecipeUpgradeWidth(recipeId, tentType, widthIn, widthOut, (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public ShapedRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            if ("empty".equals(recipeId.func_110623_a())) {
                return EMPTY;
            }
            ShapedRecipe recipe = super.func_199426_a_(recipeId, buffer);
            TentType tentType = TentType.getById(buffer.readByte());
            TentWidth widthIn = TentWidth.getById(buffer.readByte());
            TentWidth widthOut = TentWidth.getById(buffer.readByte());
            return new RecipeUpgradeWidth(recipeId, tentType, widthIn, widthOut, (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public void func_199427_a_(PacketBuffer buffer, ShapedRecipe recipeIn) {
            super.func_199427_a_(buffer, recipeIn);
            RecipeUpgradeWidth recipe = (RecipeUpgradeWidth)recipeIn;
            buffer.writeByte((int)recipe.getTent().getId());
            buffer.writeByte((int)recipe.getWidthIn().getId());
            buffer.writeByte((int)recipe.getWidthOut().getId());
        }
    }
}

