/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.dimension;

import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nomadictents.dimension.TentChunkGenerator;
import nomadictents.init.TentConfig;

public class TentDimension
extends Dimension {
    public static final int TENT_SPACING = 32;
    public static final int FLOOR_Y = 70;
    public static final Direction STRUCTURE_DIR = Direction.EAST;

    public TentDimension(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn, 1.0f);
    }

    public ChunkGenerator<?> func_186060_c() {
        return new TentChunkGenerator((IWorld)this.getWorld(), this.getDimension(), new OverworldGenSettings());
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        return null;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return null;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public boolean func_76569_d() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    public boolean func_76567_e() {
        return (Boolean)TentConfig.CONFIG.ALLOW_SLEEP_TENT_DIM.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }
}

