/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.dimension;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.event.TentEvent;
import nomadictents.structure.util.TentData;

public class TentTeleporter
extends Teleporter {
    private final TentData tentData;
    private final BlockPos tentDoorPos;
    private final DyeColor color;
    private final double prevX;
    private final double prevY;
    private final double prevZ;
    private final float prevYaw;
    private final DimensionType dimensionFrom;
    private final DimensionType dimensionTo;
    private final MinecraftServer server;

    public TentTeleporter(MinecraftServer serverIn, DimensionType dimFrom, DimensionType dimTo, BlockPos doorPos, DyeColor colorIn, double oldX, double oldY, double oldZ, float oldYaw, TentData data) {
        super(serverIn.func_71218_a(dimTo));
        this.server = serverIn;
        this.dimensionFrom = dimFrom;
        this.dimensionTo = dimTo;
        this.tentDoorPos = doorPos;
        this.color = colorIn;
        this.prevX = oldX;
        this.prevY = oldY;
        this.prevZ = oldZ;
        this.prevYaw = oldYaw;
        this.tentData = data;
    }

    public TentTeleporter(DimensionType worldFrom, DimensionType worldTo, TileEntityTentDoor te) {
        this(te.func_145831_w().func_73046_m(), worldFrom, worldTo, te.getDoorPos(), te.getTentData().getColor(), te.getPrevX(), te.getPrevY(), te.getPrevZ(), te.getPrevFacing(), te.getTentData());
    }

    public boolean func_85188_a(Entity entity) {
        if (entity == null || !entity.func_70089_S() || entity.field_70170_p.func_201670_d() || !ForgeHooks.onTravelToDimension((Entity)entity, (DimensionType)this.dimensionTo)) {
            return false;
        }
        double entityX = this.getX();
        double entityY = this.getY();
        double entityZ = this.getZ();
        float yaw = this.getYaw();
        float pitch = entity.field_70125_A;
        TentEvent.TentResult result = TentEvent.TentResult.NONE;
        ServerWorld worldFrom = entity.func_184102_h().func_71218_a(entity.field_71093_bK);
        ServerWorld worldTo = this.server.func_71218_a(this.dimensionTo);
        worldTo.func_217349_x(new BlockPos(entityX, entityY, entityZ));
        if (TentDimensionManager.isTent(this.dimensionTo)) {
            entityX += (double)entity.func_213311_cf();
            result = this.tentData.getStructure().generateInTentDimension(this.dimensionFrom, (World)worldTo, this.tentDoorPos, this.tentData, this.prevX, this.prevY, this.prevZ, this.prevYaw, this.color);
            worldTo.func_72912_H().func_76068_b(TentDimensionManager.getOverworld(entity.func_184102_h()).func_72912_H().func_76073_f());
        }
        entity.field_71093_bK = this.dimensionTo;
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.func_213293_j(0.0, 0.0, 0.0);
            player.field_184851_cj = true;
            player.func_200619_a(worldTo, entityX, entityY, entityZ, yaw, pitch);
            player.func_70012_b(entityX, entityY, entityZ, yaw, pitch);
            player.func_70634_a(entityX, entityY, entityZ);
            player.field_71088_bW = player.func_82147_ab() + 10;
        } else {
            entity.func_213319_R();
            Entity copy = entity.func_200600_R().func_200721_a((World)worldTo);
            if (copy != null) {
                copy.func_180432_n(entity);
                if (entity instanceof ThrowableEntity || entity instanceof ItemEntity || entity instanceof AbstractArrowEntity) {
                    entityY += 0.9;
                }
                copy.func_70012_b(entityX, entityY, entityZ, yaw, pitch);
                copy.func_213317_d(entity.func_213322_ci().func_216369_h(Vec3d.func_189986_a((float)entity.field_70125_A, (float)this.getYaw()).func_72432_b()));
                worldTo.func_217460_e(copy);
                worldFrom.func_82742_i();
                worldTo.func_82742_i();
                entity.remove(false);
            }
        }
        if (TentDimensionManager.isTent(this.dimensionTo) && worldTo.func_175625_s(this.tentDoorPos) instanceof TileEntityTentDoor) {
            TentEvent.PostEnter event = new TentEvent.PostEnter((TileEntityTentDoor)worldTo.func_175625_s(this.tentDoorPos), entity, result);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
        return true;
    }

    public boolean func_222268_a(Entity entity, float f) {
        return this.func_85188_a(entity);
    }

    public double getX() {
        return TentDimensionManager.isTent(this.dimensionTo) ? (double)this.tentDoorPos.func_177958_n() + 0.9 : this.prevX;
    }

    public double getY() {
        return TentDimensionManager.isTent(this.dimensionTo) ? (double)this.tentDoorPos.func_177956_o() + 0.01 : this.prevY;
    }

    public double getZ() {
        return TentDimensionManager.isTent(this.dimensionTo) ? (double)this.tentDoorPos.func_177952_p() + 0.5 : this.prevZ;
    }

    public float getYaw() {
        return TentDimensionManager.isTent(this.dimensionTo) ? -90.0f : MathHelper.func_76142_g((float)(this.prevYaw + 180.0f));
    }

    public String toString() {
        return "\n[TentTeleporter]\nstructure=" + this.tentData + "\ntentDoorPos=" + this.tentDoorPos + "\nprevX=" + this.prevX + "\nprevY=" + this.prevY + "\nprevZ=" + this.prevZ + "\nprevFacing=" + this.prevYaw + "\nprevDimID=" + this.dimensionFrom + "\nnextDimID=" + this.dimensionTo + "\n";
    }
}

