/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.event;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.DyeColor;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import nomadictents.init.Content;
import nomadictents.init.NomadicTents;
import nomadictents.structure.util.TentData;
import nomadictents.structure.util.TentType;

public class ClientTentEventHandler {
    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        NomadicTents.LOGGER.debug("nomadictents: RegisterColorHandler");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                ItemColors colors = event.getItemColors();
                if (colors != null) {
                    colors.func_199877_a((stack, tintIndex) -> {
                        TentData data = new TentData(stack);
                        if (data.getTent() == TentType.SHAMIANA) {
                            if (data.getColor() == DyeColor.BLACK) {
                                return 0x303030;
                            }
                            float[] rgbFloat = data.getColor().func_193349_f();
                            return MathHelper.func_180183_b((float)rgbFloat[0], (float)rgbFloat[1], (float)rgbFloat[2]);
                        }
                        return -1;
                    }, new IItemProvider[]{() -> Content.ITEM_TENT});
                }
            }
            catch (Exception e) {
                NomadicTents.LOGGER.error("Caught exception while registering ItemColors");
                NomadicTents.LOGGER.error(e.getMessage());
            }
        });
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        NomadicTents.LOGGER.debug("nomadictents: RegisterRenderType");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                ClientTentEventHandler.registerRenderCutout(Content.FRAME_BEDOUIN_ROOF, Content.FRAME_BEDOUIN_WALL, Content.FRAME_INDLU_WALL, Content.FRAME_SHAMIANA_WALL, Content.FRAME_TEPEE_WALL, Content.FRAME_YURT_ROOF, Content.FRAME_YURT_WALL);
            }
            catch (Exception e) {
                NomadicTents.LOGGER.error("Caught exception while registering RenderType");
                NomadicTents.LOGGER.error(e.getMessage());
            }
        });
    }

    private static void registerRenderCutout(Block ... blocks) {
        for (Block b : blocks) {
            RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228643_e_());
        }
    }
}

