/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.proxies;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nomadictents.block.BlockBarrier;
import nomadictents.block.BlockBedouinRoof;
import nomadictents.block.BlockBedouinWall;
import nomadictents.block.BlockIndluWall;
import nomadictents.block.BlockShamianaWall;
import nomadictents.block.BlockTentDoorHGM;
import nomadictents.block.BlockTentDoorSML;
import nomadictents.block.BlockTentFrame;
import nomadictents.block.BlockTepeeWall;
import nomadictents.block.BlockUnbreakable;
import nomadictents.block.BlockYurtRoof;
import nomadictents.block.BlockYurtWall;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.crafting.RecipeUpgradeColor;
import nomadictents.crafting.RecipeUpgradeDepth;
import nomadictents.crafting.RecipeUpgradeWidth;
import nomadictents.dimension.BiomeTent;
import nomadictents.init.Content;
import nomadictents.init.NomadicTents;
import nomadictents.item.ItemDepthUpgrade;
import nomadictents.item.ItemMallet;
import nomadictents.item.ItemSuperMallet;
import nomadictents.item.ItemTent;

public class CommonProxy {
    public void registerBiome(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(new BiomeTent().setRegistryName("nomadictents", "tent_biome"));
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BlockBarrier().setRegistryName("nomadictents", "tentmod_barrier"), (Block)new BlockUnbreakable(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151664_l)).setRegistryName("nomadictents", "super_dirt")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BlockYurtWall(false).setRegistryName("nomadictents", "yurt_wall_outer"), (Block)new BlockYurtWall(false).setRegistryName("nomadictents", "yurt_wall_inner"), (Block)new BlockYurtRoof(false).setRegistryName("nomadictents", "yurt_roof"), (Block)new BlockBedouinWall(false).setRegistryName("nomadictents", "bed_wall"), (Block)new BlockBedouinRoof(false).setRegistryName("nomadictents", "bed_roof"), (Block)new BlockIndluWall(false).setRegistryName("nomadictents", "indlu_wall_outer"), (Block)new BlockIndluWall(false).setRegistryName("nomadictents", "indlu_wall_inner"), new BlockTepeeWall("tepee_wall_blank", false), new BlockTepeeWall("tepee_wall_black", false), new BlockTepeeWall("tepee_wall_red", false), new BlockTepeeWall("tepee_wall_yellow", false), new BlockTepeeWall("tepee_wall_orange", false), new BlockTepeeWall("tepee_wall_white", false), new BlockTepeeWall("tepee_wall_hope", false), new BlockTepeeWall("tepee_wall_sun", false), new BlockTepeeWall("tepee_wall_creeper", false), new BlockTepeeWall("tepee_wall_universe", false), new BlockTepeeWall("tepee_wall_eagle", false), new BlockTepeeWall("tepee_wall_triforce", false), new BlockTepeeWall("tepee_wall_dreamcatcher", false), new BlockTepeeWall("tepee_wall_rain", false), new BlockTepeeWall("tepee_wall_magic", false)});
        for (DyeColor color : DyeColor.values()) {
            event.getRegistry().register((IForgeRegistryEntry)new BlockShamianaWall(color, false));
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{new BlockTentDoorSML("yurt_door_0"), new BlockTentDoorHGM("yurt_door_1"), new BlockTentDoorSML("tepee_door_0"), new BlockTentDoorHGM("tepee_door_1"), new BlockTentDoorSML("bed_door_0"), new BlockTentDoorHGM("bed_door_1"), new BlockTentDoorSML("indlu_door_0"), new BlockTentDoorHGM("indlu_door_1"), new BlockTentDoorSML("shamiana_door_0"), new BlockTentDoorHGM("shamiana_door_1")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{new BlockTentFrame(() -> Content.YURT_WALL_OUTER.func_176223_P(), "frame_yurt_wall"), new BlockTentFrame(() -> (BlockState)Content.YURT_ROOF.func_176223_P().func_206870_a((IProperty)BlockYurtRoof.OUTSIDE, (Comparable)Boolean.valueOf(true)), "frame_yurt_roof"), new BlockTentFrame(() -> Content.TEPEE_WALL_BLANK.func_176223_P(), "frame_tepee_wall"), new BlockTentFrame(() -> Content.BEDOUIN_WALL.func_176223_P(), "frame_bed_wall"), new BlockTentFrame(() -> Content.BEDOUIN_ROOF.func_176223_P(), "frame_bed_roof"), new BlockTentFrame(() -> Content.INDLU_WALL_OUTER.func_176223_P(), "frame_indlu_wall"), new BlockTentFrame(() -> Content.SHAMIANA_WALL_WHITE.func_176223_P(), "frame_shamiana_wall")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BlockYurtWall(true).setRegistryName("nomadictents", "cos_yurt_wall_outer"), (Block)new BlockYurtWall(true).setRegistryName("nomadictents", "cos_yurt_wall_inner"), (Block)new BlockYurtRoof(true).setRegistryName("nomadictents", "cos_yurt_roof"), (Block)new BlockBedouinWall(true).setRegistryName("nomadictents", "cos_bed_wall"), (Block)new BlockBedouinRoof(true).setRegistryName("nomadictents", "cos_bed_roof"), (Block)new BlockIndluWall(true).setRegistryName("nomadictents", "cos_indlu_wall_outer"), (Block)new BlockIndluWall(true).setRegistryName("nomadictents", "cos_indlu_wall_inner"), new BlockTepeeWall("cos_tepee_wall_blank", true), new BlockTepeeWall("cos_tepee_wall_black", true), new BlockTepeeWall("cos_tepee_wall_red", true), new BlockTepeeWall("cos_tepee_wall_yellow", true), new BlockTepeeWall("cos_tepee_wall_orange", true), new BlockTepeeWall("cos_tepee_wall_white", true), new BlockTepeeWall("cos_tepee_wall_hope", true), new BlockTepeeWall("cos_tepee_wall_sun", true), new BlockTepeeWall("cos_tepee_wall_creeper", true), new BlockTepeeWall("cos_tepee_wall_universe", true), new BlockTepeeWall("cos_tepee_wall_eagle", true), new BlockTepeeWall("cos_tepee_wall_triforce", true), new BlockTepeeWall("cos_tepee_wall_dreamcatcher", true), new BlockTepeeWall("cos_tepee_wall_rain", true), new BlockTepeeWall("cos_tepee_wall_magic", true)});
        for (DyeColor color : DyeColor.values()) {
            event.getRegistry().register((IForgeRegistryEntry)new BlockShamianaWall(color, true));
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemTent().setRegistryName("nomadictents", "tent"), (Item)new ItemMallet((IItemTier)ItemTier.IRON).setRegistryName("nomadictents", "mallet"), (Item)new ItemSuperMallet((IItemTier)ItemTier.DIAMOND).setRegistryName("nomadictents", "super_mallet"), CommonProxy.makeItem("tent_canvas"), CommonProxy.makeItem("yurt_wall_piece"), CommonProxy.makeItem("tepee_wall_piece"), CommonProxy.makeItem("bed_wall_piece"), CommonProxy.makeItem("indlu_wall_piece"), CommonProxy.makeItem("shamiana_wall_piece"), CommonProxy.makeItem("tent_upgrade_gold"), CommonProxy.makeItem("tent_upgrade_obsidian"), CommonProxy.makeItem("tent_upgrade_diamond"), new ItemDepthUpgrade("depth_upgrade_stone"), new ItemDepthUpgrade("depth_upgrade_iron"), new ItemDepthUpgrade("depth_upgrade_gold"), new ItemDepthUpgrade("depth_upgrade_obsidian"), new ItemDepthUpgrade("depth_upgrade_diamond"), CommonProxy.makeIB(Content.TENT_BARRIER), CommonProxy.makeIB(Content.SUPER_DIRT), CommonProxy.makeIB(Content.YURT_WALL_OUTER), CommonProxy.makeIB(Content.YURT_ROOF), CommonProxy.makeIB(Content.YURT_WALL_INNER), CommonProxy.makeIB(Content.BEDOUIN_WALL), CommonProxy.makeIB(Content.BEDOUIN_ROOF), CommonProxy.makeIB(Content.INDLU_WALL_OUTER), CommonProxy.makeIB(Content.INDLU_WALL_INNER), CommonProxy.makeIB(Content.TEPEE_WALL_BLANK), CommonProxy.makeIB(Content.TEPEE_WALL_BLACK), CommonProxy.makeIB(Content.TEPEE_WALL_RED), CommonProxy.makeIB(Content.TEPEE_WALL_YELLOW), CommonProxy.makeIB(Content.TEPEE_WALL_ORANGE), CommonProxy.makeIB(Content.TEPEE_WALL_WHITE), CommonProxy.makeIB(Content.TEPEE_WALL_HOPE), CommonProxy.makeIB(Content.TEPEE_WALL_SUN), CommonProxy.makeIB(Content.TEPEE_WALL_CREEPER), CommonProxy.makeIB(Content.TEPEE_WALL_UNIVERSE), CommonProxy.makeIB(Content.TEPEE_WALL_EAGLE), CommonProxy.makeIB(Content.TEPEE_WALL_TRIFORCE), CommonProxy.makeIB(Content.TEPEE_WALL_DREAMCATCHER), CommonProxy.makeIB(Content.TEPEE_WALL_RAIN), CommonProxy.makeIB(Content.TEPEE_WALL_MAGIC)});
        for (DyeColor color : DyeColor.values()) {
            event.getRegistry().register((IForgeRegistryEntry)CommonProxy.makeIB(BlockShamianaWall.getShamianaBlock(color, true)));
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{CommonProxy.makeIB(Content.COS_YURT_WALL_INNER), CommonProxy.makeIB(Content.COS_YURT_WALL_OUTER), CommonProxy.makeIB(Content.COS_YURT_ROOF), CommonProxy.makeIB(Content.COS_BEDOUIN_WALL), CommonProxy.makeIB(Content.COS_BEDOUIN_ROOF), CommonProxy.makeIB(Content.COS_INDLU_WALL_OUTER), CommonProxy.makeIB(Content.COS_INDLU_WALL_INNER), CommonProxy.makeIB(Content.COS_TEPEE_WALL_BLANK), CommonProxy.makeIB(Content.COS_TEPEE_WALL_BLACK), CommonProxy.makeIB(Content.COS_TEPEE_WALL_RED), CommonProxy.makeIB(Content.COS_TEPEE_WALL_YELLOW), CommonProxy.makeIB(Content.COS_TEPEE_WALL_ORANGE), CommonProxy.makeIB(Content.COS_TEPEE_WALL_WHITE), CommonProxy.makeIB(Content.COS_TEPEE_WALL_HOPE), CommonProxy.makeIB(Content.COS_TEPEE_WALL_SUN), CommonProxy.makeIB(Content.COS_TEPEE_WALL_CREEPER), CommonProxy.makeIB(Content.COS_TEPEE_WALL_UNIVERSE), CommonProxy.makeIB(Content.COS_TEPEE_WALL_EAGLE), CommonProxy.makeIB(Content.COS_TEPEE_WALL_TRIFORCE), CommonProxy.makeIB(Content.COS_TEPEE_WALL_DREAMCATCHER), CommonProxy.makeIB(Content.COS_TEPEE_WALL_RAIN), CommonProxy.makeIB(Content.COS_TEPEE_WALL_MAGIC)});
        for (DyeColor color : DyeColor.values()) {
            event.getRegistry().register((IForgeRegistryEntry)CommonProxy.makeIB(BlockShamianaWall.getShamianaBlock(color, false)));
        }
    }

    public void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event) {
        TileEntityType.Builder builder = TileEntityType.Builder.func_223042_a(TileEntityTentDoor::new, (Block[])new Block[]{Content.YURT_DOOR_SML, Content.YURT_DOOR_HGM, Content.TEPEE_DOOR_SML, Content.TEPEE_DOOR_HGM, Content.BEDOUIN_DOOR_SML, Content.BEDOUIN_DOOR_HGM, Content.INDLU_DOOR_SML, Content.INDLU_DOOR_HGM, Content.SHAMIANA_DOOR_SML, Content.SHAMIANA_DOOR_HGM});
        event.getRegistry().register(builder.func_206865_a(null).setRegistryName("nomadictents", "tileentitytentdoor"));
    }

    public void registerDimension(RegistryEvent.Register<ModDimension> event) {
        event.getRegistry().register((IForgeRegistryEntry)Content.MOD_DIMENSION);
    }

    public void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)new RecipeUpgradeWidth.Factory().setRegistryName("nomadictents", "tent_upgrade_width"), (IRecipeSerializer)new RecipeUpgradeDepth.Factory().setRegistryName("nomadictents", "tent_upgrade_depth"), (IRecipeSerializer)new RecipeUpgradeColor.Factory().setRegistryName("nomadictents", "tent_upgrade_color")});
    }

    private static final Item makeItem(String name) {
        return (Item)new Item(new Item.Properties().func_200916_a(NomadicTents.TAB)).setRegistryName("nomadictents", name);
    }

    private static final BlockItem makeIB(Block base) {
        BlockItem ib = new BlockItem(base, new Item.Properties().func_200916_a(NomadicTents.TAB));
        ib.setRegistryName(base.getRegistryName());
        return ib;
    }
}

