/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.DyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import nomadictents.block.BlockTentDoor;
import nomadictents.block.BlockUnbreakable;
import nomadictents.block.Categories;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.dimension.TentDimension;
import nomadictents.event.TentEvent;
import nomadictents.init.Content;
import nomadictents.init.NomadicTents;
import nomadictents.init.TentConfig;
import nomadictents.structure.util.Blueprint;
import nomadictents.structure.util.Blueprints;
import nomadictents.structure.util.TentData;
import nomadictents.structure.util.TentDepth;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public abstract class StructureBase {
    public static final Predicate<BlockState> REPLACE_BLOCK_PRED = new Predicate<BlockState>(){

        @Override
        public boolean test(BlockState b) {
            Material m = b.func_185904_a();
            return m.func_76222_j() || m == Material.field_151579_a || m == Material.field_151585_k || m == Material.field_151587_i || m == Material.field_151586_h || m == Material.field_151584_j || m == Material.field_151597_y || m == Material.field_151577_b || b.func_177230_c() instanceof SnowBlock;
        }
    };

    public final TentEvent.TentResult generateInTentDimension(DimensionType worldServerFrom, World worldIn, BlockPos doorPos, TentData data, double prevX, double prevY, double prevZ, float prevFacing, DyeColor color) {
        boolean recolorTent;
        TentEvent.TentResult result = TentEvent.TentResult.NONE;
        BlockPos corner = doorPos.func_177982_a(0, 0, -1 * data.getWidth().getDoorZ());
        boolean structureExists = worldIn.func_180495_p(doorPos).func_177230_c() instanceof BlockTentDoor;
        TentData prevData = structureExists ? StructureBase.getDoorAt(worldIn, doorPos).getTentData() : data.copy();
        boolean rebuildTent = !structureExists || data.getWidth() != prevData.getWidth();
        boolean buildPlatform = !structureExists || rebuildTent;
        boolean upgradePlatform = structureExists && !buildPlatform && data.getDepth() != prevData.getDepth();
        boolean bl = recolorTent = structureExists && prevData.getColor() != color;
        if (!structureExists) {
            result = TentEvent.TentResult.BUILT_FIRST;
        } else if (rebuildTent) {
            data.getStructure().remove(worldIn, doorPos, prevData, TentDimension.STRUCTURE_DIR);
            result = TentEvent.TentResult.UPGRADED;
        }
        if (recolorTent) {
            result = TentEvent.TentResult.UPGRADED;
        }
        if (!structureExists || rebuildTent || recolorTent) {
            this.generate(worldIn, doorPos, data, TentDimension.STRUCTURE_DIR, data.getDoorBlock(), data.getWallBlock(true), data.getRoofBlock(true));
        }
        if (buildPlatform) {
            StructureBase.generatePlatform(worldIn, corner.func_177979_c(1), data.getWidth(), data.getDepth());
        } else if (upgradePlatform) {
            StructureBase.upgradePlatformDepth(worldIn, corner.func_177979_c(1), data.getWidth(), prevData.getDepth(), data.getDepth());
            result = TentEvent.TentResult.UPGRADED;
        }
        StructureBase.updateDoorInfo(worldIn, doorPos, data, prevX, prevY, prevZ, prevFacing, worldServerFrom);
        return result;
    }

    public static final TileEntityTentDoor getDoorAt(World worldIn, BlockPos doorPos) {
        TileEntity te = worldIn.func_175625_s(doorPos);
        if (te instanceof TileEntityTentDoor) {
            return (TileEntityTentDoor)te;
        }
        NomadicTents.LOGGER.error("Error! Failed to retrieve TileEntityTentDoor at " + doorPos.toString());
        return null;
    }

    public static final boolean updateDoorInfo(World worldIn, BlockPos doorPos, TentData data, double prevX, double prevY, double prevZ, float prevFacing, DimensionType prevDimension) {
        TileEntityTentDoor door = StructureBase.getDoorAt(worldIn, doorPos);
        if (door != null) {
            data.setID(TileEntityTentDoor.getTentID(doorPos));
            door.setTentData(data);
            door.setOverworldXYZ(prevX, prevY, prevZ);
            door.setPrevFacing(prevFacing);
            door.setPrevDimension(prevDimension);
            return true;
        }
        return false;
    }

    private static boolean generatePlatform(World worldIn, BlockPos corner, TentWidth size, TentDepth depth) {
        int sqWidth = size.getSquareWidth();
        Block bottom = Content.SUPER_DIRT;
        Block floor = TentConfig.CONFIG.getFloorBlock();
        for (int i = 0; i < sqWidth; ++i) {
            for (int j = 0; j < sqWidth; ++j) {
                BlockPos at = corner.func_177982_a(i, 0, j);
                Block blockUp = worldIn.func_180495_p(at.func_177981_b(1)).func_177230_c();
                boolean placeFloor = false;
                Block filler = null;
                if (blockUp instanceof Categories.ITentBlockBase) {
                    placeFloor = true;
                    filler = bottom;
                } else {
                    int maxExpectedHeight = 24;
                    for (int f = 1; f < maxExpectedHeight; ++f) {
                        if (!(worldIn.func_180495_p(at.func_177981_b(f)).func_177230_c() instanceof Categories.ITentBlockBase)) continue;
                        placeFloor = true;
                        filler = floor;
                        break;
                    }
                }
                if (!placeFloor || filler == null) continue;
                int l = depth.getLayers();
                for (int k = 0; k < l; ++k) {
                    Block b = worldIn.func_180495_p(at.func_177979_c(k)).func_177230_c();
                    if (b != Blocks.field_150350_a && !(b instanceof BlockUnbreakable)) continue;
                    worldIn.func_175656_a(at.func_177979_c(k), filler.func_176223_P());
                }
                worldIn.func_180501_a(at.func_177979_c(depth.getLayers()), bottom.func_176223_P(), 2);
            }
        }
        return true;
    }

    private static boolean upgradePlatformDepth(World worldIn, BlockPos corner, TentWidth size, TentDepth depthPrev, TentDepth depthCur) {
        int sqWidth = size.getSquareWidth();
        int numLayers = depthCur.getLayers() - depthPrev.getLayers();
        Block bottom = Content.SUPER_DIRT;
        Block floor = TentConfig.CONFIG.getFloorBlock();
        for (int i = 0; i < sqWidth; ++i) {
            for (int j = 0; j < sqWidth; ++j) {
                BlockPos bottomPos = corner.func_177982_a(i, -depthPrev.getLayers(), j);
                if (worldIn.func_180495_p(bottomPos).func_177230_c() != bottom) continue;
                for (int k = 0; k < numLayers; ++k) {
                    BlockPos at = bottomPos.func_177979_c(k);
                    Block filler = worldIn.func_180495_p(at.func_177981_b(1)).func_177230_c() instanceof BlockUnbreakable && !((BlockUnbreakable)worldIn.func_180495_p(at.func_177981_b(1)).func_177230_c()).isCosmetic() ? bottom : floor;
                    worldIn.func_175656_a(at, filler.func_176223_P());
                }
                worldIn.func_175656_a(bottomPos.func_177979_c(numLayers), bottom.func_176223_P());
            }
        }
        return false;
    }

    private static boolean removePlatform(World worldIn, BlockPos corner, TentWidth size, TentDepth depth) {
        int sqWidth = size.getSquareWidth();
        int layers = depth.getLayers() + 1;
        Block bottom = Content.SUPER_DIRT;
        Block floor = TentConfig.CONFIG.getFloorBlock();
        for (int i = 0; i < sqWidth; ++i) {
            for (int j = 0; j < sqWidth; ++j) {
                for (int k = 0; k < layers; ++k) {
                    BlockPos at = corner.func_177982_a(i, -k, j);
                    Block blockAt = worldIn.func_180495_p(at).func_177230_c();
                    if (blockAt != bottom && blockAt != floor && !(blockAt instanceof BlockUnbreakable)) continue;
                    worldIn.func_180501_a(at, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        return true;
    }

    public static final BlockPos getPosFromDoor(BlockPos doorPos, BlockPos offset, Direction forward) {
        return StructureBase.getPosFromDoor(doorPos, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), forward);
    }

    public static final BlockPos getPosFromDoor(BlockPos doorPos, int disForward, int disUp, int disRight, Direction forward) {
        Direction right = forward.func_176746_e();
        return doorPos.func_177967_a(forward, disForward).func_177967_a(right, disRight).func_177981_b(disUp);
    }

    public static void buildDoor(World world, BlockPos doorBase, BlockState door, Direction dir) {
        if (door.func_177230_c() instanceof BlockTentDoor) {
            Direction.Axis axis = dir.func_176740_k() == Direction.Axis.Z ? Direction.Axis.Z : Direction.Axis.X;
            BlockState doorL = (BlockState)((BlockState)door.func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a(BlockTentDoor.AXIS, (Comparable)axis);
            BlockState doorU = (BlockState)((BlockState)door.func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a(BlockTentDoor.AXIS, (Comparable)axis);
            world.func_180501_a(doorBase, doorL, 3);
            world.func_180501_a(doorBase.func_177981_b(1), doorU, 3);
        }
    }

    public static BlockPos getCenter(BlockPos doorBase, TentWidth width, Direction dir) {
        return StructureBase.getPosFromDoor(doorBase, Math.floorDiv(width.getSquareWidth(), 2), 0, 0, dir);
    }

    public void buildLayer(World worldIn, BlockPos door, Direction dirForward, BlockState state, BlockPos[] coordinates) {
        for (BlockPos coord : coordinates) {
            BlockPos pos = StructureBase.getPosFromDoor(door, coord, dirForward);
            worldIn.func_180501_a(pos, state, 3);
        }
    }

    public boolean generateFrameStructure(World worldIn, BlockPos doorBase, TentData data, Direction dirForward) {
        return this.generate(worldIn, doorBase, data.copyForOverworld(), dirForward, data.getDoorBlock(), data.getTent().getFrameBlock(false), data.getTent().getFrameBlock(true));
    }

    public boolean remove(World worldIn, BlockPos doorPos, TentData data, Direction dirForward) {
        BlockState air = Blocks.field_150350_a.func_176223_P();
        boolean flag = this.generate(worldIn, doorPos, data, dirForward, air, air, air);
        if (worldIn.func_175625_s(doorPos) instanceof TileEntityTentDoor) {
            worldIn.func_175713_t(doorPos);
        }
        if (worldIn.func_175625_s(doorPos.func_177981_b(1)) instanceof TileEntityTentDoor) {
            worldIn.func_175713_t(doorPos.func_177981_b(1));
        }
        return flag;
    }

    public static final boolean validateArray(World worldIn, BlockPos doorPos, BlockPos[] posArray, Direction facing, Predicate<BlockState> predicate) {
        for (BlockPos p : posArray) {
            BlockPos check = StructureBase.getPosFromDoor(doorPos, p, facing);
            if (StructureBase.validateBlock(worldIn, check, predicate)) continue;
            return false;
        }
        return true;
    }

    public static final boolean validateBlock(World worldIn, BlockPos pos, Predicate<BlockState> p) {
        return p.test(worldIn.func_180495_p(pos));
    }

    public Direction getValidFacing(World worldIn, BlockPos doorBase, TentData data) {
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            if (!this.isValidForFacing(worldIn, data, doorBase, dir)) continue;
            return dir;
        }
        return null;
    }

    public boolean canGenerateFrameStructure(World worldIn, BlockPos doorBase, TentData data, Direction dirForward) {
        Blueprint bp = StructureBase.getBlueprints(data.copyForOverworld());
        if (bp.hasWallCoords() && !StructureBase.validateArray(worldIn, doorBase, bp.getWallCoords(), dirForward, REPLACE_BLOCK_PRED)) {
            return false;
        }
        return !bp.hasRoofCoords() || StructureBase.validateArray(worldIn, doorBase, bp.getRoofCoords(), dirForward, REPLACE_BLOCK_PRED);
    }

    public boolean isValidForFacing(World worldIn, TentData data, BlockPos doorBase, Direction facing) {
        Blueprint bp = StructureBase.getBlueprints(data);
        Predicate<BlockState> TENT_PRED = StructureBase.makeTentPred(data);
        if (bp.hasWallCoords() && !StructureBase.validateArray(worldIn, doorBase, bp.getWallCoords(), facing, TENT_PRED)) {
            return false;
        }
        return !bp.hasRoofCoords() || StructureBase.validateArray(worldIn, doorBase, bp.getRoofCoords(), facing, TENT_PRED);
    }

    public static Blueprint getBlueprints(TentData data) {
        return Blueprints.get(data.getTent(), data.getWidth());
    }

    public static Predicate<BlockState> makeTentPred(TentData data) {
        return b -> data.getTent().getInterface().isAssignableFrom(b.func_177230_c().getClass());
    }

    public abstract boolean generate(World var1, BlockPos var2, TentData var3, Direction var4, BlockState var5, BlockState var6, BlockState var7);

    public abstract TentType getTentType();
}

