/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.INBTSerializable;
import nomadictents.block.BlockTentDoorHGM;
import nomadictents.block.BlockTentDoorSML;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.init.Content;
import nomadictents.init.NomadicTents;
import nomadictents.item.ItemTent;
import nomadictents.structure.StructureBase;
import nomadictents.structure.util.TentDepth;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public class TentData
implements INBTSerializable<CompoundNBT> {
    public static final String KEY_TENT_CUR = "TentType";
    public static final String KEY_WIDTH_CUR = "WidthCur";
    public static final String KEY_DEPTH_CUR = "DepthCur";
    public static final String KEY_ID = "ID";
    public static final String KEY_COLOR = "TentColor";
    private TentType tent = TentType.getById((byte)0);
    private TentWidth width = TentWidth.getById((byte)0);
    private TentDepth depth = TentDepth.getById((byte)0);
    private DyeColor color = DyeColor.WHITE;
    private long locationID = -32768L;

    public TentData() {
    }

    public TentData(CompoundNBT nbt) {
        this();
        if (nbt != null) {
            this.deserializeNBT(nbt);
        }
    }

    public TentData(ItemStack tentStack) {
        this(tentStack != null && !tentStack.func_190926_b() && tentStack.func_77973_b() instanceof ItemTent ? tentStack.func_190925_c("TentData") : null);
    }

    public TentData setAll(TentType tentIn, TentWidth widthIn, TentDepth depthIn) {
        this.tent = tentIn;
        this.width = widthIn;
        this.depth = depthIn;
        return this;
    }

    public TentData copy() {
        return new TentData().setAll(this.tent, this.width, this.depth).setID(this.locationID).setColor(this.color);
    }

    public TentData copyForOverworld() {
        return this.copy().setWidth(this.width.getOverworldSize());
    }

    public boolean isValid() {
        return this.locationID != -32768L;
    }

    public TentData setTent(TentType tentIn) {
        this.tent = tentIn;
        return this;
    }

    public TentData setWidth(TentWidth widthIn) {
        this.width = widthIn;
        return this;
    }

    public TentData setDepth(TentDepth depthIn) {
        this.depth = depthIn;
        return this;
    }

    public TentData setID(long id) {
        this.locationID = id;
        return this;
    }

    public TentData setColor(DyeColor colorIn) {
        this.color = colorIn;
        return this;
    }

    public TentType getTent() {
        return this.tent;
    }

    public TentWidth getWidth() {
        return this.width;
    }

    public TentDepth getDepth() {
        return this.depth;
    }

    public long getID() {
        return this.locationID;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BlockState getDoorBlock() {
        boolean xl = this.getWidth().isXL();
        Block block = this.getDoorBlockRaw(xl);
        EnumProperty<TentWidth> sizeEnum = xl ? BlockTentDoorHGM.SIZE_HGM : BlockTentDoorSML.SIZE_SML;
        return (BlockState)block.func_176223_P().func_206870_a(sizeEnum, (Comparable)((Object)this.getWidth()));
    }

    private Block getDoorBlockRaw(boolean isXL) {
        switch (this.getTent()) {
            case YURT: {
                return isXL ? Content.YURT_DOOR_HGM : Content.YURT_DOOR_SML;
            }
            case TEPEE: {
                return isXL ? Content.TEPEE_DOOR_HGM : Content.TEPEE_DOOR_SML;
            }
            case BEDOUIN: {
                return isXL ? Content.BEDOUIN_DOOR_HGM : Content.BEDOUIN_DOOR_SML;
            }
            case INDLU: {
                return isXL ? Content.INDLU_DOOR_HGM : Content.INDLU_DOOR_SML;
            }
            case SHAMIANA: {
                return isXL ? Content.SHAMIANA_DOOR_HGM : Content.SHAMIANA_DOOR_SML;
            }
        }
        return Content.YURT_DOOR_SML;
    }

    public BlockState getRoofBlock(boolean isInsideTent) {
        return this.tent.getRoofBlock(isInsideTent);
    }

    public BlockState getFrameBlock(boolean isRoof) {
        return this.tent.getFrameBlock(isRoof);
    }

    public BlockState getWallBlock(boolean isInsideTent) {
        return this.tent.getWallBlock(isInsideTent);
    }

    public static boolean shouldUpdate(TentData oldData, TentData newData) {
        return oldData.getWidth() != newData.getWidth() || oldData.getDepth() != newData.getDepth() || oldData.getColor() != newData.getColor();
    }

    public static void applyToTileEntity(PlayerEntity player, ItemStack stack, TileEntityTentDoor te) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("TentData")) {
            NomadicTents.LOGGER.error("ItemStack did not have any NBT information to pass to the TileEntity!");
            te.func_145831_w().func_175713_t(te.func_174877_v());
            return;
        }
        te.setTentData(new TentData(stack));
        te.setOverworldXYZ(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        te.setPrevFacing(player.field_70177_z);
        te.setOwner(PlayerEntity.func_175147_b((String)player.func_200200_C_().func_150261_e()));
    }

    public static TentData getRandom(Random rand) {
        TentType t = TentType.values()[rand.nextInt(TentType.values().length)];
        TentWidth w = TentWidth.values()[rand.nextInt(TentWidth.values().length)];
        TentDepth d = TentDepth.values()[rand.nextInt(TentDepth.values().length)];
        return new TentData().setAll(t, w, d);
    }

    public ItemStack getDropStack() {
        return this.writeTo(new ItemStack((IItemProvider)Content.ITEM_TENT, 1));
    }

    public ItemStack writeTo(ItemStack stack) {
        stack.func_196082_o().func_218657_a("TentData", (INBT)this.serializeNBT());
        return stack;
    }

    public StructureBase getStructure() {
        return this.tent.getStructure();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.tent != null) {
            nbt.func_74774_a(KEY_TENT_CUR, this.tent.getId());
            nbt.func_74774_a(KEY_WIDTH_CUR, this.width.getId());
            nbt.func_74774_a(KEY_DEPTH_CUR, this.depth.getId());
            nbt.func_74772_a(KEY_ID, this.locationID);
            nbt.func_74768_a(KEY_COLOR, this.color.func_196059_a());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.tent = TentType.getById(nbt.func_74771_c(KEY_TENT_CUR));
        this.width = TentWidth.getById(nbt.func_74771_c(KEY_WIDTH_CUR));
        this.depth = TentDepth.getById(nbt.func_74771_c(KEY_DEPTH_CUR));
        this.locationID = nbt.func_74763_f(KEY_ID);
        this.color = nbt.func_74764_b(KEY_COLOR) ? DyeColor.func_196056_a((int)nbt.func_74762_e(KEY_COLOR)) : DyeColor.WHITE;
    }

    public String toString() {
        return "\nStructureData: [TENT = " + this.tent.func_176610_l() + "; WIDTH = " + this.width.func_176610_l() + "; DEPTH = " + this.depth.func_176610_l() + ";\nPREV_WIDTH = ; ID = " + this.locationID + "; COLOR = " + (this.color != null ? this.color.func_176610_l() : "null") + "]";
    }
}

