/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure.util;

import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import nomadictents.structure.util.TentData;

public enum TentDepth implements IStringSerializable
{
    NORMAL(1),
    DOUBLE(2),
    TRIPLE(3),
    QUADRUPLE(4),
    QUINTUPLE(5),
    SEXTUPLE(6);

    private static final int NUM_ENTRIES;
    private final int layers;

    private TentDepth(int i) {
        this.layers = i;
    }

    public int getLayers() {
        return this.layers;
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    public static TentDepth getById(byte id) {
        return TentDepth.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(NUM_ENTRIES - 1))];
    }

    public static int maxUpgrades(TentData data) {
        return data.getWidth().getMaxDepth() - 1;
    }

    public static int countUpgrades(TentData data) {
        return data.getDepth().ordinal();
    }

    public static TentDepth getByName(String name) {
        for (TentDepth d : TentDepth.values()) {
            if (!name.equals(d.func_176610_l())) continue;
            return d;
        }
        return NORMAL;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase();
    }

    static {
        NUM_ENTRIES = TentDepth.values().length;
    }
}

