/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure.util;

import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import nomadictents.init.TentConfig;

public enum TentWidth implements IStringSerializable
{
    SMALL(5, TextFormatting.RED){

        @Override
        public int getMaxDepth() {
            return (Integer)TentConfig.CONFIG.DEPTH_SMALL.get();
        }
    }
    ,
    MEDIUM(7, TextFormatting.BLUE){

        @Override
        public int getMaxDepth() {
            return (Integer)TentConfig.CONFIG.DEPTH_MEDIUM.get();
        }
    }
    ,
    LARGE(9, TextFormatting.GREEN){

        @Override
        public int getMaxDepth() {
            return (Integer)TentConfig.CONFIG.DEPTH_LARGE.get();
        }
    }
    ,
    HUGE(11, TextFormatting.YELLOW){

        @Override
        public int getMaxDepth() {
            return (Integer)TentConfig.CONFIG.DEPTH_HUGE.get();
        }
    }
    ,
    GIANT(13, TextFormatting.DARK_PURPLE){

        @Override
        public int getMaxDepth() {
            return (Integer)TentConfig.CONFIG.DEPTH_GIANT.get();
        }
    }
    ,
    MEGA(15, TextFormatting.AQUA){

        @Override
        public int getMaxDepth() {
            return (Integer)TentConfig.CONFIG.DEPTH_MEGA.get();
        }
    };

    public static final int NUM_ENTRIES;
    private final TextFormatting textFormatting;
    private final int squareWidth;
    private final int doorOffsetZ;

    private TentWidth(int sq, TextFormatting formatting) {
        this.textFormatting = formatting;
        this.squareWidth = sq;
        this.doorOffsetZ = this.ordinal() + 2;
    }

    public int getSquareWidth() {
        return this.squareWidth;
    }

    public int getDoorZ() {
        return this.doorOffsetZ;
    }

    public TextFormatting getTooltipColor() {
        return this.textFormatting;
    }

    public boolean isXL() {
        return this == HUGE || this == GIANT || this == MEGA;
    }

    public TentWidth getOverworldSize() {
        if (((Boolean)TentConfig.CONFIG.USE_ACTUAL_SIZE.get()).booleanValue()) {
            return this;
        }
        if (this.isXL()) {
            return MEDIUM;
        }
        return SMALL;
    }

    public static TentWidth getSmallest() {
        return TentWidth.values()[0];
    }

    public static TentWidth getLargest() {
        return TentWidth.values()[NUM_ENTRIES - 1];
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    public static TentWidth getById(byte id) {
        return TentWidth.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(NUM_ENTRIES - 1))];
    }

    public static TentWidth getByName(String name) {
        if (name != null && !name.isEmpty()) {
            for (TentWidth w : TentWidth.values()) {
                if (!name.equals(w.func_176610_l())) continue;
                return w;
            }
        }
        return SMALL;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase();
    }

    public abstract int getMaxDepth();

    static {
        NUM_ENTRIES = TentWidth.values().length;
    }
}

