/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;
import pregenerator.base.impl.PregenCheckBox;
import pregenerator.base.impl.PregenSlider;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public abstract class BasePregenScreen
extends Screen {
    protected int centerX;
    protected int centerY;
    protected int tick;

    protected BasePregenScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    protected void init() {
        super.init();
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.buttons.clear();
        this.children.clear();
    }

    public void tick() {
        super.tick();
        ++this.tick;
    }

    public void render(int mouseX, int mouseY, float partial) {
        super.render(mouseX, mouseY, partial);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public Button registerButton(int x, int y, int width, int height, String name, Button.IPressable pressable) {
        ExtendedButton button = new ExtendedButton(x + this.centerX, y + this.centerY, width, height, name, pressable);
        this.addButton((Widget)button);
        return button;
    }

    public Button registerSimpleButton(int x, int y, int width, int height, String name, Button.IPressable pressable) {
        ExtendedButton button = new ExtendedButton(x, y, width, height, name, pressable);
        this.addButton((Widget)button);
        return button;
    }

    public PregenCheckBox registerCheckbox(int x, int y, int width, int height, String text, boolean checked) {
        PregenCheckBox check = new PregenCheckBox(x + this.centerX, y + this.centerY, width, height, text, checked, T -> {});
        this.addButton((Widget)check);
        return check;
    }

    public PregenCheckBox registerCheckbox(int x, int y, int width, int height, String text, boolean checked, Button.IPressable handler) {
        PregenCheckBox check = new PregenCheckBox(x + this.centerX, y + this.centerY, width, height, text, checked, handler);
        this.addButton((Widget)check);
        return check;
    }

    public TextFieldWidget registerText(int x, int y, int width, int height, String original) {
        TextFieldWidget widget = new TextFieldWidget(this.font, x + this.centerX, y + this.centerY, width, height, "");
        widget.func_146180_a(original);
        this.addButton((Widget)widget);
        return widget;
    }

    public TextFieldWidget registerSimpleText(int x, int y, int width, int height, String original) {
        TextFieldWidget widget = new TextFieldWidget(this.font, x, y, width, height, "");
        widget.func_146180_a(original);
        this.addButton((Widget)widget);
        return widget;
    }

    public PregenSlider registerSlider(int x, int y, int width, int height, String prefix, String postfix, double minVal, double maxVal, double currentVal, Slider.ISlider par) {
        PregenSlider slider = new PregenSlider(x + this.centerX, y + this.centerY, width, height, prefix, postfix, minVal, maxVal, currentVal, par);
        this.addButton((Widget)slider);
        return slider;
    }

    public PregenSlider registerSimpleSlider(int x, int y, int width, int height, String prefix, String postfix, double minVal, double maxVal, double currentVal, Slider.ISlider par) {
        PregenSlider slider = new PregenSlider(x, y, width, height, prefix, postfix, minVal, maxVal, currentVal, par);
        this.addButton((Widget)slider);
        return slider;
    }

    public void drawText(String s, int x, int y, int color) {
        this.font.func_211126_b(s, (float)(this.centerX + x), (float)(this.centerY + y), color);
    }

    public void drawSimpleText(String s, int x, int y, int color) {
        this.font.func_211126_b(s, (float)x, (float)y, color);
    }

    public void drawCenterText(String s, int x, int y, int color) {
        this.font.func_211126_b(s, (float)(this.centerX + x - this.font.func_78256_a(s) / 2), (float)(this.centerY + y), color);
    }

    public void drawLeftText(String s, int x, int y, int color) {
        this.font.func_211126_b(s, (float)(this.centerX + x - this.font.func_78256_a(s)), (float)(this.centerY + y), color);
    }

    public void renderTextureWithOffset(float x, float y, float width, float height) {
        this.renderTexture(x + (float)this.centerX, y + (float)this.centerY, width, height);
    }

    public void renderTexture(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), (double)this.getBlitOffset()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)this.getBlitOffset()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, (double)this.getBlitOffset()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, (double)this.getBlitOffset()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawSimpleRect(int minX, int minY, int maxX, int maxY, int color, boolean drop) {
        if (drop) {
            BasePregenScreen.fill((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            BasePregenScreen.fill((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            BasePregenScreen.fill((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            BasePregenScreen.fill((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        BasePregenScreen.fill((int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
    }

    public void drawRectangle(int xSize, int ySize, int xOffset, int yOffset, int color, boolean drop) {
        int minX = this.centerX - xSize + xOffset;
        int minY = this.centerY - ySize + yOffset;
        int maxX = this.centerX + xSize + xOffset;
        int maxY = this.centerY + ySize + yOffset;
        if (drop) {
            BasePregenScreen.fill((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            BasePregenScreen.fill((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            BasePregenScreen.fill((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            BasePregenScreen.fill((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        BasePregenScreen.fill((int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
    }

    public boolean isInsideBox(int mouseX, int mouseY, int minX, int minY, int maxX, int maxY) {
        return mouseX >= this.centerX + minX && mouseX < this.centerX + maxX && mouseY >= this.centerY + minY && mouseY <= this.centerY + maxY;
    }

    public void fill(float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)minX, (double)maxY, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_225582_a_((double)maxX, (double)maxY, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_225582_a_((double)maxX, (double)minY, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_225582_a_((double)minX, (double)minY, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    public void drawQuadArea(float left, float top, float right, float bottom, BufferBuilder builder, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        builder.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
        builder.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
        builder.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
        builder.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(f, f1, f2, f3).func_181675_d();
    }

    public void sendToServer(IPregenPacket packet) {
        NetworkManager.INSTANCE.sendToServer(packet);
    }
}

