/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui.commands;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.client.gui.CommandScreen;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.networking.command.RemoveTaskPacket;
import pregenerator.common.networking.command.TaskListRequest;

public class TaskListScreen
extends BasePregenScreen {
    static final String ACTIVE = TextFormatting.GOLD + " [Active]" + TextFormatting.RESET;
    int index;
    String name;
    List<IBaseTask<?>> tasks = new ObjectArrayList();
    Set<String> activeTasks = new ObjectOpenHashSet();
    int offset = 0;
    Button[] buttons = new Button[7];
    boolean byName = true;

    public TaskListScreen(int index, String name) {
        super((ITextComponent)new StringTextComponent("Gen Task List"));
        this.index = index;
        this.name = name;
    }

    @Override
    protected void init() {
        super.init();
        for (int i = 0; i < 7; ++i) {
            int index = i;
            this.buttons[i] = this.registerButton(146, 0, 43, 14, "Remove", T -> this.remove(index));
        }
        this.registerButton(-30, 90, 60, 14, "Back", this::back);
        this.registerButton(117, -95, 14, 14, "-", T -> this.move(-1));
        this.registerButton(132, -95, 14, 14, "+", T -> this.move(1));
        this.registerButton(-146, -95, 100, 14, "Sort: " + (this.byName ? "Task Name" : "Task Size"), this::sort);
        this.sendToServer(new TaskListRequest(this.index));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tick % 100 == 0) {
            this.sendToServer(new TaskListRequest(this.index));
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int i;
        int height;
        this.renderBackground();
        this.drawRectangle(170, 105, 20, 0, -3750202, false);
        this.drawRectangle(145, 84, 0, 5, -7631989, true);
        int totalHeight = 168;
        ObjectArrayList textDisplay = new ObjectArrayList();
        int i2 = 0;
        while (i2 + this.offset < this.tasks.size()) {
            List list;
            StringBuilder builder = new StringBuilder();
            builder.append(this.tasks.get(i2 + this.offset).getTaskDescription().func_150254_d().replace("[", "").replace("]", ""));
            if (this.activeTasks.contains(this.tasks.get(i2 + this.offset).getName())) {
                builder.append(ACTIVE);
            }
            if ((height = (list = this.font.func_78271_c(builder.toString(), 290)).size() * 12) > totalHeight) break;
            textDisplay.add(list);
            totalHeight -= height;
            ++i2;
        }
        totalHeight = 150;
        int yOffset = -81;
        int m = textDisplay.size() - 1;
        for (int i3 = 0; i3 < m; ++i3) {
            height = ((List)textDisplay.get(i3)).size() * 12;
            this.hLine(this.centerX - 145, this.centerX + 144, yOffset + height + this.centerY, -13158601);
            yOffset += height;
            totalHeight -= height;
        }
        while (totalHeight >= 20) {
            this.hLine(this.centerX - 145, this.centerX + 144, yOffset + 24 + this.centerY, -13158601);
            totalHeight -= 24;
            yOffset += 24;
        }
        super.render(mouseX, mouseY, partialTicks);
        this.drawCenterText(this.name, 4, -99, 0x404040);
        this.drawLeftText(this.offset + "/" + Math.max(0, this.tasks.size() - 1), 114, -88, 0x404040);
        int yLevel = -77;
        for (i = 0; i < textDisplay.size(); ++i) {
            List list = (List)textDisplay.get(i);
            for (int y = 0; y < list.size(); ++y) {
                this.drawText((String)list.get(y), -144, yLevel + y * 10, -1);
            }
            this.buttons[i].y = this.centerY + yLevel + (list.size() > 2 ? list.size() * 2 : 0);
            this.buttons[i].visible = true;
            yLevel += list.size() * 12;
        }
        for (i = textDisplay.size(); i < this.buttons.length; ++i) {
            this.buttons[i].visible = false;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        int scrolling = (int)scroll;
        if (scrolling != 0) {
            this.offset = MathHelper.func_76125_a((int)(this.offset - scrolling), (int)0, (int)Math.max(0, this.tasks.size() - 1));
            return true;
        }
        return false;
    }

    public void onTasksReceived(int newIndex, List<IBaseTask<?>> newTasks, Set<String> active) {
        if (this.index != newIndex) {
            return;
        }
        this.tasks.clear();
        this.tasks.addAll(newTasks);
        this.activeTasks.clear();
        this.activeTasks.addAll(active);
        this.sortList();
    }

    private void sort(Button button) {
        this.byName = !this.byName;
        button.setMessage(this.byName ? "Sort: Task Name" : "Sort: Task Size");
        this.sortList();
    }

    public void sortList() {
        this.tasks.sort((K, V) -> this.byName ? K.getName().compareToIgnoreCase(V.getName()) : Long.compare(V.getTaskSize(), K.getTaskSize()));
    }

    private void remove(int index) {
        if ((index += this.offset) < 0 || index >= this.tasks.size()) {
            return;
        }
        this.sendToServer(new RemoveTaskPacket(this.tasks.get(index).getName()));
    }

    private void back(Button button) {
        this.getMinecraft().func_147108_a((Screen)new CommandScreen());
    }

    private void move(int scrolling) {
        this.offset = MathHelper.func_76125_a((int)(this.offset - scrolling), (int)0, (int)Math.max(0, this.tasks.size() - 1));
    }
}

