/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.data.tasks;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.util.math.ChunkPos;
import pregenerator.client.preview.data.ChunkData;
import pregenerator.client.preview.data.tasks.ITask;
import pregenerator.client.preview.world.IFileProvider;

public class GetChunkTask
implements ITask {
    int x;
    int z;
    Cache<Long, ChunkData> cache;
    ChunkData data;
    boolean done = false;

    public GetChunkTask(int x, int z, Cache<Long, ChunkData> cache) {
        this.x = x;
        this.z = z;
        this.cache = cache;
    }

    @Override
    public void handleTask(FileChannel chunkData, FileChannel heightData, IFileProvider provider) throws IOException {
        ByteBuffer chunkBuffer;
        if (provider.has(this.x, this.z) && (chunkBuffer = ITask.readBytes(chunkData, provider.get(this.x, this.z, IFileProvider.FileType.CHUNK_DATA), IFileProvider.FileType.CHUNK_DATA.getOffset())).get() > 0) {
            this.data = ChunkData.createChunkDataFromBuffer(chunkBuffer, ITask.readBytes(heightData, provider.get(this.x, this.z, IFileProvider.FileType.HEIGHT_DATA), IFileProvider.FileType.HEIGHT_DATA.getOffset()));
            if (this.data != null) {
                this.cache.put((Object)ChunkPos.func_77272_a((int)this.x, (int)this.z), (Object)this.data);
            }
        }
        this.done = true;
    }

    public ChunkData getData() {
        return this.data;
    }

    public void join(long timeout) {
        try {
            while (!this.done && timeout > 0L) {
                Thread.sleep(1L);
                --timeout;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

