/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.ChunkPregenerator;
import pregenerator.client.preview.data.tasks.ITask;
import pregenerator.client.preview.world.IFileProvider;
import pregenerator.client.preview.world.IHeightProvider;

public class ChunkCache
implements IFileProvider,
IHeightProvider {
    public static final Logger LOGGER = LogManager.getLogger((String)"Preview Cache");
    Cache<Integer, int[]> heightCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    Deque<ITask> tasks = new ConcurrentLinkedDeque<ITask>();
    FileChannel chunkData;
    FileChannel heightData;
    File chunkFile;
    File heightFile;
    BitSet generated = new BitSet(4000000);
    BitSet lit = new BitSet(4000000);
    int[] dataIndexes = new int[4000000];
    int currentIndex = 0;

    public ChunkCache(File chunk, File height) throws IOException {
        this.chunkFile = chunk;
        this.heightFile = height;
        this.chunkData = FileChannel.open(chunk.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.heightData = FileChannel.open(height.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Arrays.fill(this.dataIndexes, -1);
    }

    public boolean isFullyFinished() {
        return this.lit.equals(this.generated);
    }

    public int getChunksToLight() {
        return this.generated.cardinality() - this.lit.cardinality();
    }

    public void addTask(ITask task) {
        this.tasks.add(task);
    }

    public void update() {
        while (!this.tasks.isEmpty()) {
            try {
                this.tasks.removeFirst().handleTask(this.chunkData, this.heightData, this);
            }
            catch (Exception e) {
                ChunkPregenerator.LOGGER.catching((Throwable)e);
            }
        }
    }

    public FileChannel getChunkData() {
        return this.chunkData;
    }

    public void close() {
        try {
            if (this.chunkData != null) {
                this.chunkData.force(true);
                this.chunkData.close();
                this.chunkData = null;
            }
            if (this.heightData != null) {
                this.heightData.force(true);
                this.heightData.close();
                this.heightData = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean has(int x, int z) {
        int index = this.index(x, z);
        return index >= 0 && index < 4000000 && this.dataIndexes[index] != -1;
    }

    @Override
    public long get(int x, int z, IFileProvider.FileType type) {
        int index = this.index(x, z);
        return index < 0 || index >= 4000000 ? -1L : (long)this.dataIndexes[index] * type.getOffset();
    }

    @Override
    public long getOrCreate(int x, int z, IFileProvider.FileType type) {
        int index = this.index(x, z);
        if (index >= 0 && index < 4000000) {
            if (this.dataIndexes[index] == -1) {
                this.dataIndexes[index] = this.currentIndex++;
            }
            return (long)this.dataIndexes[index] * type.getOffset();
        }
        return -1L;
    }

    @Override
    public long getTotalOffset(IFileProvider.FileType type) {
        return (long)this.currentIndex * type.getOffset();
    }

    @Override
    public int getStored() {
        return this.currentIndex;
    }

    public boolean isChunkLit(int x, int z) {
        int index = this.index(x, z);
        return index >= 0 && index < 4000000 && this.lit.get(index);
    }

    @Override
    public void setChunkProgress(int x, int z, boolean isLit) {
        int index = this.index(x, z);
        if (index >= 0 && index < 4000000) {
            this.generated.set(index);
            if (isLit) {
                this.lit.set(index);
            }
        }
    }

    private int index(int x, int z) {
        return (z + 1000) * 2000 + (x + 1000);
    }

    @Override
    public void store(int x, int z, int[] heights) {
        int index = this.index(x, z);
        if (index > 0 || index < 4000000) {
            this.heightCache.put((Object)index, (Object)heights);
        }
    }

    @Override
    public int get(int x, int z, int defaultValue) {
        int[] data = this.getAll(x >> 4, z >> 4);
        return data.length <= 0 ? 0 : data[(z & 0xF) * 16 + (x & 0xF)];
    }

    @Override
    public int[] getAll(int x, int z) {
        if (this.has(x, z)) {
            int index = this.index(x, z);
            int[] cachedData = (int[])this.heightCache.getIfPresent((Object)index);
            if (cachedData == null) {
                cachedData = this.loadData(x, z);
                this.heightCache.put((Object)index, (Object)cachedData);
            }
            return cachedData;
        }
        return new int[0];
    }

    private int[] loadData(int x, int z) {
        try {
            ByteBuffer buffer = ITask.readBytes(this.heightData, this.get(x, z, IFileProvider.FileType.HEIGHT_DATA), IFileProvider.FileType.HEIGHT_DATA.getOffset());
            if (buffer.get() > 0) {
                int[] heightData = new int[256];
                for (int i = 0; i < heightData.length; ++i) {
                    heightData[i] = buffer.get() + 128;
                }
                return heightData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[0];
    }
}

