/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.world;

import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.io.File;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.ChainedChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import pregenerator.client.preview.world.CustomServer;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.ReflectionHelper;

public class WorldSeed {
    CreateWorldScreen prev;
    Screen mainMenu;
    TextFieldWidget seedField;
    TextFieldWidget nameField;
    String folder;
    String name;
    long seed;
    WorldSettings settings;

    public WorldSeed(CreateWorldScreen original) {
        this.prev = original;
        this.mainMenu = (Screen)ReflectionHelper.getValueSave(CreateWorldScreen.class, original, new String[]{"parentScreen", "field_146332_f"});
        this.nameField = (TextFieldWidget)ReflectionHelper.getValueSave(CreateWorldScreen.class, original, new String[]{"worldNameField", "field_146333_g"});
        this.seedField = (TextFieldWidget)ReflectionHelper.getValueSave(CreateWorldScreen.class, original, new String[]{"worldSeedField", "field_146335_h"});
        this.folder = (String)ReflectionHelper.getValueSave(CreateWorldScreen.class, original, new String[]{"saveDirName", "field_146336_i"});
        this.loadSeed();
    }

    public void setSeed(String seedName) {
        this.seedField.func_146180_a(seedName);
        ReflectionHelper.setValueSave(CreateWorldScreen.class, this.prev, seedName, "worldSeed", "field_219022_p");
        this.loadSeed();
    }

    public CustomServer createServer() {
        Minecraft mc = Minecraft.func_71410_x();
        System.gc();
        try {
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(mc.func_110437_J(), UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(mc.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
            SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            PlayerProfileCache.func_187320_a((boolean)false);
            CustomServer server = new CustomServer(mc, "Preview", this.name, this.settings, yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache, p_213246_1_ -> {
                TrackingChunkStatusListener trackingchunkstatuslistener = new TrackingChunkStatusListener(p_213246_1_ + 0);
                trackingchunkstatuslistener.func_219521_a();
                return new ChainedChunkStatusListener((IChunkStatusListener)trackingchunkstatuslistener, T -> {});
            });
            server.func_71256_s();
            ReflectionHelper.setValueSave(Minecraft.class, mc, (Object)server, "integratedServer", "field_71437_Z");
            for (DimensionType type : DimensionType.func_212681_b()) {
                DimensionManager.keepLoaded((DimensionType)type, (boolean)true);
            }
            return server;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Starting integrated server");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Starting integrated server");
            crashreportcategory.func_71507_a("Level ID", (Object)"Preview");
            crashreportcategory.func_71507_a("Level Name", (Object)this.name);
            throw new ReportedException(crashreport);
        }
    }

    public void destroyServer(CustomServer server) {
        if (server != null && !server.func_71241_aa()) {
            for (DimensionType type : DimensionType.func_212681_b()) {
                DimensionManager.keepLoaded((DimensionType)type, (boolean)false);
            }
            if (ServerManager.INSTANCE.isRunning()) {
                ServerManager.INSTANCE.removeTask(null, T -> {});
            }
            server.func_71263_m(true);
            ReflectionHelper.setValueSave(Minecraft.class, Minecraft.func_71410_x(), null, "integratedServer", "field_71437_Z");
        }
    }

    private void loadSeed() {
        this.name = this.nameField.func_146179_b();
        long textSeed = WorldSeed.makeSeed(this.seedField.func_146179_b());
        this.seed = textSeed == 0L ? new Random().nextLong() : textSeed;
        this.seedField.func_146180_a(Long.toString(this.seed));
        if (this.settings == null) {
            this.createSettings();
            return;
        }
        this.settings.func_77165_h().onGUICreateWorldPress();
        WorldSettings newSettings = new WorldSettings(this.seed, this.settings.func_77162_e(), this.settings.func_77164_g(), this.settings.func_77158_f(), this.settings.func_77165_h());
        if (this.settings.func_77167_c()) {
            newSettings.func_77159_a();
        }
        if (this.settings.func_77163_i()) {
            newSettings.func_77166_b();
        }
        this.settings = newSettings;
    }

    private void createSettings() {
        int index = (Integer)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"selectedIndex", "field_146331_K"});
        GameType type = GameType.func_77142_a((String)((String)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"gameMode", "field_146342_r"})));
        boolean structures = (Boolean)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"generateStructuresEnabled", "field_146341_s"});
        boolean hardcore = (Boolean)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"hardCoreMode", "field_146337_w"});
        boolean bonusChest = (Boolean)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"hardCoreMode", "field_146337_w"});
        boolean cheats = (Boolean)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"bonusChestEnabled", "field_146338_v"});
        WorldType.field_77139_a[index].onGUICreateWorldPress();
        WorldSettings worldsettings = new WorldSettings(this.seed, type, structures, hardcore, WorldType.field_77139_a[index]);
        worldsettings.func_205390_a((JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)this.prev.field_146334_a));
        if (bonusChest && !hardcore) {
            worldsettings.func_77159_a();
        }
        if (cheats && !hardcore) {
            worldsettings.func_77166_b();
        }
        this.settings = worldsettings;
    }

    public static long makeSeed(String input) {
        try {
            return !StringUtils.func_151246_b((String)input) ? Long.parseLong(input) : 0L;
        }
        catch (NumberFormatException var7) {
            return input.hashCode();
        }
    }

    public static File getPreviewFolder() {
        return new File(Minecraft.func_71410_x().field_71412_D, "saves/Preview");
    }

    public static File getMapFolder() {
        return new File(WorldSeed.getPreviewFolder(), "previewData");
    }

    public static void removePreview() {
        WorldSeed.remove(WorldSeed.getPreviewFolder(), false);
    }

    public static void remove(File file, boolean itself) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File subFile : file.listFiles()) {
                    WorldSeed.remove(subFile, true);
                }
            }
            if (itself) {
                file.delete();
            }
        }
    }

    public Screen getPrevScreen() {
        return this.prev;
    }

    public Screen getMainMenu() {
        return this.mainMenu;
    }

    public String getSeedString() {
        return this.seedField.func_146179_b();
    }

    public long getSeed() {
        return this.seed;
    }

    public String getMapName() {
        return this.folder;
    }
}

