/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.ChunkPos;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.generator.tasks.ITask;

public class GenTaskStorage
extends SimpleTaskStorage<ITask> {
    Object2ObjectMap<String, ExecutionMemory> memory = new Object2ObjectOpenHashMap();

    public GenTaskStorage(Runnable dirtyCall) {
        super(dirtyCall, ITask::loadTask, ITask::saveTask);
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        ListNBT list = nbt.func_150295_c("memory", 10);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            CompoundNBT data = list.func_150305_b(i);
            this.memory.put((Object)data.func_74779_i("id"), (Object)new ExecutionMemory(this.getDirtyCall()).read(data));
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        super.write(compound);
        ListNBT data = new ListNBT();
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(this.memory)) {
            CompoundNBT nbt = new CompoundNBT();
            ((ExecutionMemory)entry.getValue()).write(nbt);
            nbt.func_74778_a("id", (String)entry.getKey());
            data.add((Object)nbt);
        }
        compound.func_218657_a("memory", (INBT)data);
        return compound;
    }

    @Override
    public boolean removeTask(String name) {
        if (super.removeTask(name)) {
            this.memory.keySet().retainAll(this.getTasks());
            return true;
        }
        return false;
    }

    public ExecutionMemory getMemory(String name) {
        ExecutionMemory entry = (ExecutionMemory)this.memory.get((Object)name);
        if (entry == null) {
            entry = new ExecutionMemory(this.getDirtyCall());
            this.memory.put((Object)name, (Object)entry);
            this.markDirty();
        }
        return entry;
    }

    public static class ExecutionMemory {
        Long2ByteMap chunkMemory = new Long2ByteOpenHashMap();
        Runnable dirty;

        public ExecutionMemory(Runnable dirty) {
            this.dirty = dirty;
        }

        public ExecutionMemory read(CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c("data", 10);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                CompoundNBT data = list.func_150305_b(i);
                this.chunkMemory.put(data.func_74763_f("k"), data.func_74771_c("v"));
            }
            return this;
        }

        public CompoundNBT write(CompoundNBT nbt) {
            ListNBT list = new ListNBT();
            for (Long2ByteMap.Entry entry : this.chunkMemory.long2ByteEntrySet()) {
                CompoundNBT data = new CompoundNBT();
                data.func_74772_a("k", entry.getLongKey());
                data.func_74774_a("v", entry.getByteValue());
                list.add((Object)data);
            }
            nbt.func_218657_a("data", (INBT)list);
            return nbt;
        }

        public void addEntry(ChunkPos pos, int value) {
            this.chunkMemory.put(pos.func_201841_a(), (byte)value);
            this.dirty.run();
        }

        public void addEntry(ChunkPos pos, boolean value) {
            this.chunkMemory.put(pos.func_201841_a(), (byte)(value ? 2 : 1));
            this.dirty.run();
        }

        public byte getState(long pos) {
            return this.chunkMemory.get(pos);
        }
    }
}

