/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Optional;
import java.util.function.LongPredicate;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterestData;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionSectionCache;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.base.IInteruptable;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.collections.Long2ObjectCustomMap;
import pregenerator.common.utils.misc.ReflectionHelper;

public class ChunkDeleter
implements IInteruptable {
    private DimensionType type;
    private File worldFile;
    private ServerWorld world;
    private Long2ObjectLinkedOpenHashMap<RegionFile> chunkCache;
    private Long2ObjectLinkedOpenHashMap<RegionFile> poiCache;
    private ServerChunkProvider provider;
    private LongPredicate predicate = T -> ChunkProcess.getHolder(this.provider, ChunkPos.func_77272_a((int)SectionPos.func_218173_b((long)T), (int)SectionPos.func_218153_d((long)T))) == null;
    private Long2ObjectMap<Optional<PointOfInterestData>> pointsOfInterest;
    private long totalChunks = 0L;
    private ObjectArrayList<DeleterEntry> entries = ObjectArrayList.wrap((Object[])new DeleterEntry[0]);

    public ChunkDeleter(DimensionType type, File worldFile, ServerWorld world) {
        this.type = type;
        this.worldFile = type.func_212679_a(worldFile);
        this.world = world;
        if (this.world != null) {
            this.provider = world.func_72863_F();
            this.chunkCache = this.getCache(this.provider);
            this.poiCache = this.getCache(this.provider.func_217231_i());
            Long2ObjectMap map = (Long2ObjectMap)ReflectionHelper.getValueSave(RegionSectionCache.class, this.provider.func_217231_i(), new String[]{"data", "field_219121_b"});
            if (map instanceof Long2ObjectCustomMap) {
                this.pointsOfInterest = map;
            } else {
                this.pointsOfInterest = new Long2ObjectCustomMap(map);
                ReflectionHelper.setValueSave(RegionSectionCache.class, this.provider.func_217231_i(), this.pointsOfInterest, "data", "field_219121_b");
            }
        }
    }

    public ChunkDeleter init(Long2ObjectMap<BitSet> maps, ChunkPos center, IProcess.PrepaireProgress progress) {
        if (!progress.isAlive()) {
            return this;
        }
        progress.growMax(maps.size());
        this.entries.ensureCapacity(maps.size());
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(maps)) {
            progress.growValue(1);
            DeleterEntry delete = new DeleterEntry(this, new ChunkPos(ChunkPos.func_212578_a((long)entry.getLongKey()) << 5, ChunkPos.func_212579_b((long)entry.getLongKey()) << 5), (BitSet)entry.getValue());
            if (!delete.canDelete()) continue;
            this.entries.add((Object)delete);
            this.totalChunks += (long)((BitSet)entry.getValue()).cardinality();
        }
        ObjectArrays.parallelQuickSort((Object[])this.entries.elements(), (int)0, (int)this.entries.size(), (o1, o2) -> Long.compare(o2.getDistanceToCenter(center), o1.getDistanceToCenter(center)));
        return this;
    }

    public DimensionType getType() {
        return this.type;
    }

    public void start() {
        if (this.world == null) {
            return;
        }
        this.provider.func_217210_a(true);
        this.pointsOfInterest.keySet().removeIf(this.predicate);
        ObjectArrayList list = new ObjectArrayList(this.chunkCache.values());
        this.chunkCache.clear();
        for (RegionFile file : list) {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
        list = new ObjectArrayList(this.poiCache.values());
        this.poiCache.clear();
        for (RegionFile file : list) {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
    }

    public DeleterEntry getNextTask() {
        return this.entries.isEmpty() ? null : (DeleterEntry)this.entries.pop();
    }

    public boolean isDone() {
        return this.entries.isEmpty();
    }

    public long getTotal() {
        return this.totalChunks;
    }

    @Override
    public void interrupt() {
        this.entries.clear();
    }

    protected boolean canDelete(int x, int z) {
        return this.provider == null || !this.provider.func_73149_a(x, z);
    }

    static class DeleterEntry {
        ChunkDeleter owner;
        ChunkPos position;
        BitSet toDelete;
        int size;
        int skipped;
        int removed;

        public DeleterEntry(ChunkDeleter owner, ChunkPos position, BitSet toDelete) {
            this.owner = owner;
            this.position = position;
            this.toDelete = toDelete;
            this.size = toDelete.cardinality();
        }

        public boolean canDelete() {
            return new File(this.owner.worldFile, "region/r." + (this.position.field_77276_a >> 5) + "." + (this.position.field_77275_b >> 5) + ".mca").exists();
        }

        long getDistanceToCenter(ChunkPos center) {
            long x = this.position.field_77276_a - center.field_77276_a;
            long z = this.position.field_77275_b - center.field_77275_b;
            return x * x + z * z;
        }

        public int size() {
            return this.size;
        }

        public int getRemoved() {
            return this.removed;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public void update() {
            String pos = "r." + (this.position.field_77276_a >> 5) + "." + (this.position.field_77275_b >> 5) + ".mca";
            File chunkFolder = new File(this.owner.worldFile, "region");
            File poiFolder = new File(this.owner.worldFile, "poi");
            File chunkFile = new File(chunkFolder, pos);
            File poiFile = new File(poiFolder, pos);
            if (this.size == 1024) {
                try {
                    chunkFile.delete();
                    poiFile.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.removed = this.size;
                return;
            }
            try {
                this.removed = 0;
                File tempChunk = new File(this.owner.worldFile, "region/temp.mca");
                File tempPoi = new File(this.owner.worldFile, "poi/temp.mca");
                chunkFile.renameTo(tempChunk);
                poiFile.renameTo(tempPoi);
                RegionFile oldChunk = new RegionFile(tempChunk, this.owner.worldFile);
                RegionFile oldPoi = new RegionFile(tempPoi, this.owner.worldFile);
                RegionFile newChunk = new RegionFile(chunkFile, chunkFolder);
                RegionFile newPoi = new RegionFile(poiFile, poiFolder);
                int stored = 0;
                for (int i = 0; i < 1024; ++i) {
                    ChunkPos entry = new ChunkPos(i % 32, i / 32);
                    if (!(this.toDelete.get(i) && this.owner.canDelete(this.position.field_77276_a + entry.field_77276_a, this.position.field_77275_b + entry.field_77275_b) || !oldChunk.func_222667_d(entry))) {
                        try {
                            DataOutputStream out;
                            DataInputStream read = oldChunk.func_222666_a(entry);
                            if (read != null) {
                                out = newChunk.func_222661_c(entry);
                                this.copy(read, out);
                                out.close();
                            }
                            if ((read = oldPoi.func_222666_a(entry)) != null) {
                                out = newPoi.func_222661_c(entry);
                                this.copy(read, out);
                                out.close();
                            }
                            ++stored;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    ++this.removed;
                }
                this.removed = Math.min(this.removed, this.size - this.skipped);
                oldChunk.close();
                newChunk.close();
                oldPoi.close();
                newPoi.close();
                if (stored == 0) {
                    chunkFile.delete();
                    poiFile.delete();
                }
                tempChunk.delete();
                tempPoi.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public long copy(InputStream input, OutputStream output) throws IOException {
            byte[] buffer = new byte[8192];
            int n = 0;
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }
    }
}

