/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public abstract class BaseDeletionTask
implements IDeletionTask {
    String name;
    DimensionType type;

    public BaseDeletionTask(CompoundNBT nbt) {
        this(nbt.func_74779_i("name"), DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim"))));
    }

    public BaseDeletionTask(String name, DimensionType type) {
        this.name = name;
        this.type = type;
    }

    public abstract void append(ITextComponent var1);

    public abstract ChunkDeleter createTask(ServerWorld var1, IProcess.PrepaireProgress var2);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DimensionType getDimension() {
        return this.type;
    }

    @Override
    public ITextComponent getTaskDescription() {
        StringTextComponent text = new StringTextComponent("[");
        ITask.convert("Name=" + this.getName() + ",", (ITextComponent)text, TextFormatting.AQUA);
        ITask.convert("Dim=" + this.getDimension().getRegistryName().func_110623_a() + ", ", (ITextComponent)text, TextFormatting.GREEN);
        this.append((ITextComponent)text);
        return text.func_150258_a("]");
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("dim", this.type.getRegistryName().toString());
        return nbt;
    }

    @Override
    public CompletableFuture<ChunkDeleter> createTask(ServerWorld world, Executor exe, IProcess.PrepaireProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    protected File getSaveFile() {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b();
    }

    protected boolean isRegionFile(File file, String fileName) {
        return fileName.endsWith(".mca");
    }

    protected File[] getRegionFiles() {
        File[] array = new File(this.type.func_212679_a(this.getSaveFile()), "region").listFiles(this::isRegionFile);
        return array == null ? new File[]{} : array;
    }
}

