/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionCircleExpansion
extends BaseDeletionTask {
    long center;
    int minRadius;
    int maxRadius;

    public DeletionCircleExpansion(CompoundNBT nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.minRadius = nbt.func_74762_e("minRadius");
        this.maxRadius = nbt.func_74762_e("maxRadius");
    }

    public DeletionCircleExpansion(String name, DimensionType type, ChunkPos center, int minRadius, int maxRadius) {
        super(name, type);
        this.center = center.func_201841_a();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = super.write();
        nbt.func_74772_a("center", this.center);
        nbt.func_74768_a("minRadius", this.minRadius);
        nbt.func_74768_a("maxRadius", this.maxRadius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    public String getShapeName() {
        return "Circle Expansion";
    }

    @Override
    public void append(ITextComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Circle Expansion, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.field_77276_a + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=" + center.field_77275_b + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("MinRadius=" + this.minRadius + ", ", builder, TextFormatting.BLUE);
        ITask.convert("MaxRadius=" + this.maxRadius, builder, TextFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        return (long)((double)((long)this.maxRadius * 2L) * Math.PI) - (long)((double)((long)this.minRadius * 2L) * Math.PI);
    }

    @Override
    public ChunkDeleter createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter(this.type, this.getSaveFile(), world);
        ChunkPos center = new ChunkPos(this.center);
        return deleter.init(ChunkShapeBuilder.getCircleExpansionShape(center.field_77276_a, center.field_77275_b, this.minRadius, this.maxRadius, progress), center, progress);
    }
}

