/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import pregenerator.common.generator.ChunkEntry;

public class GeneratorQueue {
    final int maxActive;
    final int maxActiveFiles;
    final boolean main;
    Consumer<ChunkEntry> listener;
    List<ChunkEntry> chunkFiles = new ObjectArrayList();
    int activeChunks = 0;
    int done = 0;

    public GeneratorQueue(int maxActive, int maxActiveFiles, boolean main, Consumer<ChunkEntry> listener) {
        this.maxActive = maxActive;
        this.maxActiveFiles = maxActiveFiles;
        this.main = main;
        this.listener = listener;
    }

    public int getSubProgress() {
        return this.done;
    }

    public int getStoredChunks() {
        return this.activeChunks;
    }

    public int getActiveChunks() {
        return this.activeChunks - this.done;
    }

    public boolean isNotWorking() {
        return this.activeChunks == 0;
    }

    public boolean enqueue(ChunkEntry file) {
        if (file == null || file.isValidating() || this.activeChunks - this.done >= this.maxActive || this.chunkFiles.size() >= this.maxActiveFiles) {
            return false;
        }
        if (this.main && file.isSkipped()) {
            this.listener.accept(file);
            return true;
        }
        file.startTask(this.main);
        this.chunkFiles.add(file);
        this.activeChunks += file.getGenerationSize();
        return true;
    }

    public void interrupt() {
        int m = this.chunkFiles.size();
        for (int i = 0; i < m; ++i) {
            this.chunkFiles.get(i).interrupt();
        }
        this.chunkFiles.clear();
        this.done = 0;
        this.activeChunks = 0;
    }

    public void tick() {
        this.done = 0;
        int m = this.chunkFiles.size();
        for (int i = 0; i < m; ++i) {
            ChunkEntry file = this.chunkFiles.get(i);
            int progress = file.trackProgress();
            if (file.isFinished() || file.getGenerationSize() <= 0) {
                this.activeChunks -= file.getGenerationSize();
                this.listener.accept(file);
                this.chunkFiles.remove(i--);
                --m;
                continue;
            }
            this.done += progress;
        }
    }
}

