/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public abstract class BaseTask
implements ITask {
    String name;
    DimensionType type;
    int genType;
    boolean throwEvents;

    public BaseTask(CompoundNBT nbt) {
        this(nbt.func_74779_i("name"), DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim"))), nbt.func_74762_e("genType"));
        this.throwEvents = nbt.func_74767_n("events");
    }

    public BaseTask(String name, DimensionType type, int genType) {
        this.name = name;
        this.type = type;
        this.genType = genType;
    }

    public BaseTask setThrowEvents() {
        this.throwEvents = true;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DimensionType getDimension() {
        return this.type;
    }

    @Override
    public int getGenType() {
        return this.genType;
    }

    @Override
    public ITextComponent getTaskDescription() {
        StringTextComponent text = new StringTextComponent("[");
        ITask.convert("Name=" + this.getName() + ", ", (ITextComponent)text, TextFormatting.AQUA);
        ITask.convert("Dim=" + this.getDimension().getRegistryName().func_110623_a() + ", ", (ITextComponent)text, TextFormatting.GREEN);
        ITask.convert("GenType=" + GenerationType.values()[this.genType].name() + ", ", (ITextComponent)text, new TextFormatting[0]);
        this.append((ITextComponent)text);
        return text.func_150258_a("]");
    }

    public abstract void append(ITextComponent var1);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("dim", this.type.getRegistryName().toString());
        nbt.func_74774_a("genType", (byte)this.genType);
        if (this.throwEvents) {
            nbt.func_74757_a("events", this.throwEvents);
        }
        return nbt;
    }

    @Override
    public void onCompletion(Duration terrainTime, Duration lightTime, long total) {
    }

    @Override
    public CompletableFuture<ChunkProcess> createTask(ServerWorld world, Executor exe, IProcess.PrepaireProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    public abstract ChunkProcess createTask(ServerWorld var1, IProcess.PrepaireProgress var2);
}

