/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class WorldBorderTask
extends BaseTask {
    public WorldBorderTask(CompoundNBT nbt) {
        super(nbt);
    }

    public WorldBorderTask(String name, DimensionType type, int genType) {
        super(name, type, genType);
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String getShapeName() {
        return "Square";
    }

    @Override
    public long getTaskSize() {
        long diameter = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.type).func_175723_af().func_177722_l();
        return diameter * diameter;
    }

    @Override
    public void append(ITextComponent builder) {
        ITask.convert("Type=WorldBorder, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=0, ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=0, ", builder, TextFormatting.YELLOW);
        ITask.convert("Radius=" + ServerLifecycleHooks.getCurrentServer().func_71218_a(this.type).func_175723_af().func_177722_l() / 2, builder, TextFormatting.BLUE);
    }

    @Override
    public ChunkProcess createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        WorldBorder border = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.type).func_175723_af();
        ChunkPos pos = new ChunkPos((int)border.func_177731_f() >> 4, (int)border.func_177721_g() >> 4);
        process.init(ChunkShapeBuilder.getSquareShape(pos.field_77276_a, pos.field_77275_b, border.func_177722_l() / 2 >> 4, progress), pos, this.name, this.throwEvents, progress);
        return process;
    }
}

