/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import oshi.SystemInfo;
import oshi.hardware.Processor;
import pregenerator.ChunkPregenerator;
import pregenerator.common.commands.arguments.ISuggestableEnum;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.manager.ServerManager;

public class BenchmarkManager {
    public static final BenchmarkManager INSTANCE = new BenchmarkManager();
    List<BenchmarkResult> results = new ObjectArrayList();
    UUID sessionInstance = UUID.randomUUID();
    UUID starter = null;
    boolean sendNextBenchmark = false;

    public boolean isBenchmarkRunning() {
        return this.starter != null;
    }

    public void interruptBenchmark() {
        this.starter = null;
        this.results.clear();
    }

    public void startBenchmark(UUID starter, boolean sendAnalytics) {
        this.starter = starter;
        this.sendNextBenchmark = sendAnalytics;
    }

    public void addBenchmarkResult(long original, long chunks, Duration lightTime, Duration terrainChunk, boolean small, DimensionType type) {
        if (this.starter == null || (double)chunks / (double)original < 0.75) {
            return;
        }
        this.results.add(new BenchmarkResult(original, chunks, lightTime.toMillis(), terrainChunk.toMillis(), small, type));
    }

    public void onBenchmarksFinished(Consumer<ITextComponent> listener) {
        ServerPlayerEntity player;
        if (this.results.isEmpty() || this.starter == null) {
            this.starter = null;
            this.results.clear();
            return;
        }
        if (!ServerManager.INSTANCE.isListening(this.starter) && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.starter)) != null) {
            listener = listener.andThen(arg_0 -> ((PlayerEntity)player).func_145747_a(arg_0));
        }
        int lightScore = 0;
        int terrainScore = 0;
        long lightTime = 0L;
        long terrainTime = 0L;
        long chunks = 0L;
        for (BenchmarkResult result : this.results) {
            lightScore += result.lightScore();
            terrainScore += result.terrainScore();
            lightTime += result.lightTime;
            terrainTime += result.terrainTime;
            chunks += result.chunks;
        }
        listener.accept((ITextComponent)new StringTextComponent("Benchmark Scores"));
        listener.accept((ITextComponent)new StringTextComponent("Total Score [Chunks=" + chunks + this.time(", Terrain-Time=", terrainTime) + this.time(", Lighting-Time=", lightTime) + ", Terrain-Score=" + terrainScore + ", Lighting-Score=" + lightScore + "]"));
        for (BenchmarkResult result : this.results) {
            listener.accept((ITextComponent)new StringTextComponent(ChunkLogger.toPascalCase(result.dim.getRegistryName().func_110623_a()) + " Score [Chunks=" + result.chunks + this.time(", Terrain-Time=", result.terrainTime) + this.time(", Lighting-Time=", result.lightTime) + ", Terrain-Score=" + result.terrainScore() + ", Lighting-Score=" + result.lightScore() + "]"));
        }
        listener.accept((ITextComponent)new StringTextComponent("Score Rating: Milliseconds per Chunk. Lower => Better"));
        this.saveResults(listener);
        if (!this.sendNextBenchmark) {
            this.starter = null;
            this.results.clear();
            return;
        }
        try {
            new Thread((Runnable)new AnalyticsTask(this.createData(), false), "Pregen Analytics").start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.starter = null;
        this.results.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reportMass() {
        Path path = ServerLifecycleHooks.getCurrentServer().func_71209_f("config/pregenCache.dat").toPath();
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int a = stream.available();
            if (a < 100) {
                boolean bl2 = false;
                return bl2;
            }
            byte[] read = new byte[a];
            stream.read(read);
            new Thread((Runnable)new AnalyticsTask(read, true), "Pregen Analytics").start();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void saveResults(Consumer<ITextComponent> listener) {
        block47: {
            listener.accept((ITextComponent)new StringTextComponent("Saving Results for personal Use. Pregen_Benchmarks.json can be found in the ServerFolder"));
            Path path = ServerLifecycleHooks.getCurrentServer().func_71209_f("Pregen_Benchmarks.json").toPath();
            JsonObject results = new JsonObject();
            try (BufferedReader reader2 = Files.newBufferedReader(path);){
                results = new JsonParser().parse((Reader)reader2).getAsJsonObject();
            }
            catch (Exception reader2) {
                // empty catch block
            }
            JsonArray array = results.has("results") ? results.getAsJsonArray("results") : new JsonArray();
            results.add("results", (JsonElement)array);
            array.add((JsonElement)this.createUserData());
            try (JsonWriter writer2 = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
                writer2.setIndent(" ");
                Streams.write((JsonElement)results, (JsonWriter)writer2);
                writer2.flush();
            }
            catch (Exception writer2) {
                // empty catch block
            }
            File cache = ServerLifecycleHooks.getCurrentServer().func_71209_f("config/pregenCache.dat");
            boolean deleteOnCrash = false;
            try (RandomAccessFile file = new RandomAccessFile(cache, "rw");){
                byte[] toAdd = this.createData();
                if (file.length() <= 0L) {
                    file.writeInt(0);
                    file.writeLong(12L);
                    file.seek(0L);
                    deleteOnCrash = true;
                }
                int benchmarks = file.readInt();
                long endBytes = file.readLong();
                file.seek(endBytes);
                file.writeInt(toAdd.length);
                deleteOnCrash = true;
                file.write(toAdd);
                file.seek(0L);
                file.writeInt(benchmarks + 1);
                file.writeLong(endBytes + (long)toAdd.length + 4L);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!deleteOnCrash) break block47;
                ChunkPregenerator.LOGGER.warn("Writing to Cache has crashed.");
                try {
                    Files.deleteIfExists(cache.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private JsonObject createUserData() {
        JsonObject obj = new JsonObject();
        obj.addProperty("seed", (Number)ServerManager.INSTANCE.getSeed());
        obj.addProperty("game_version", "1.16.4");
        obj.addProperty("starter", this.starter.toString());
        obj.addProperty("max_active_tasks", (Number)ServerManager.INSTANCE.getProcessors());
        obj.addProperty("agressive_pregen", Boolean.valueOf(ServerManager.INSTANCE.isAggressive()));
        obj.addProperty("allocated_ram", (Number)Runtime.getRuntime().maxMemory());
        JsonArray data = new JsonArray();
        for (BenchmarkResult result : this.results) {
            data.add((JsonElement)result.save());
        }
        obj.add("results", (JsonElement)data);
        data = new JsonArray();
        for (ModInfo info : ModList.get().getMods()) {
            data.add(info.getModId() + ";" + info.getVersion().toString().toLowerCase());
        }
        obj.add("mods", (JsonElement)data);
        return obj;
    }

    private String time(String prefix, long value) {
        return prefix + DurationFormatUtils.formatDuration((long)value, (String)"HH:mm:ss");
    }

    private byte[] createData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(new GZIPOutputStream(out));
        stream.writeInt(0);
        stream.writeInt(1);
        stream.writeInt(35012312);
        stream.writeLong(this.starter.getMostSignificantBits());
        stream.writeLong(this.starter.getLeastSignificantBits());
        stream.writeLong(this.sessionInstance.getMostSignificantBits());
        stream.writeLong(this.sessionInstance.getLeastSignificantBits());
        stream.writeInt(ServerManager.INSTANCE.getProcessors());
        stream.writeBoolean(ServerManager.INSTANCE.isAggressive());
        stream.writeInt(-1);
        stream.writeLong(ServerManager.INSTANCE.getSeed());
        stream.writeUTF(System.getProperty("java.version"));
        stream.writeLong(Runtime.getRuntime().maxMemory());
        stream.writeUTF(this.getCPUName());
        stream.writeInt(Runtime.getRuntime().availableProcessors());
        stream.writeUTF("1.15.2");
        int amount = Math.min(this.results.size(), 1024);
        stream.writeShort(amount);
        for (int i = 0; i < amount; ++i) {
            this.results.get(i).write(stream);
        }
        List mods = ModList.get().getMods();
        amount = Math.min(mods.size(), 2048);
        stream.writeShort(amount);
        for (int i = 0; i < amount; ++i) {
            stream.writeUTF(((ModInfo)mods.get(i)).getModId() + ";" + ((ModInfo)mods.get(i)).getVersion().toString().toLowerCase());
        }
        stream.close();
        return out.toByteArray();
    }

    private String getCPUName() {
        try {
            Processor[] aprocessor = new SystemInfo().getHardware().getProcessors();
            return String.format("%dx %s", aprocessor.length, aprocessor[0]).replaceAll("\\s+", " ").toLowerCase();
        }
        catch (Throwable var3) {
            return "<unknown>";
        }
    }

    private class AnalyticsTask
    implements Runnable {
        byte[] data;
        boolean massReport;

        public AnalyticsTask(byte[] data, boolean massReport) {
            this.data = data;
            this.massReport = massReport;
        }

        @Override
        public void run() {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.massReport ? "https://pregen.speiger.com/mass" : "https://pregen.speiger.com").openConnection();
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestMethod("POST");
                connection.addRequestProperty("Content-Type", "binary");
                connection.addRequestProperty("Connection", "close");
                OutputStream out = connection.getOutputStream();
                out.write(this.data);
                out.flush();
                out.close();
                connection.getResponseCode();
                connection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum BenchmarkSize implements ISuggestableEnum
    {
        SMALL_TASK,
        LARGE_TASK;


        @Override
        public ITextComponent createSuggestion() {
            return new StringTextComponent(this == SMALL_TASK ? "40k Chunks roughly 10-30mins" : "250k Chunks roughly 1-3 hours");
        }

        public boolean isSmall() {
            return this == SMALL_TASK;
        }

        public boolean isLarge() {
            return this == LARGE_TASK;
        }
    }

    public static class BenchmarkResult {
        long originalChunks;
        long chunks;
        long lightTime;
        long terrainTime;
        boolean small;
        DimensionType dim;

        public BenchmarkResult(long originalChunks, long chunks, long lightTime, long terrainTime, boolean small, DimensionType dim) {
            this.originalChunks = originalChunks;
            this.chunks = chunks;
            this.lightTime = lightTime;
            this.terrainTime = terrainTime;
            this.small = small;
            this.dim = dim;
        }

        public int terrainScore() {
            return (int)(this.terrainTime / this.chunks);
        }

        public int lightScore() {
            return (int)(this.lightTime / this.chunks);
        }

        public void write(DataOutputStream stream) throws IOException {
            stream.writeLong(this.originalChunks);
            stream.writeLong(this.chunks);
            stream.writeLong(this.terrainTime);
            stream.writeLong(this.lightTime);
            stream.writeBoolean(this.small);
            stream.writeUTF(this.dim.getRegistryName().toString());
        }

        public JsonObject save() {
            JsonObject obj = new JsonObject();
            obj.addProperty("original_size", (Number)this.originalChunks);
            obj.addProperty("chunks", (Number)this.chunks);
            obj.addProperty("light_time", (Number)this.lightTime);
            obj.addProperty("terrain_time", (Number)this.terrainTime);
            obj.addProperty("dim", this.dim.getRegistryName().toString());
            obj.addProperty("size", (Number)(this.small ? 40000 : 250000));
            obj.addProperty("light_score", (Number)this.lightScore());
            obj.addProperty("terrain_score", (Number)this.terrainScore());
            return obj;
        }
    }
}

