/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.common.base.Supplier;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.base.IInteruptable;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.manager.IProcess;

public class TaskQueue<K extends IInteruptable, T extends IBaseTask<K>, P extends IProcess<K, T>> {
    Class<P> clz;
    boolean loadWorld;
    int size;
    PriorityQueue<P> generators = new ObjectArrayFIFOQueue();
    Map<DimensionType, IProcess<?, ?>> process;
    Supplier<SimpleTaskStorage<T>> storageProvider;

    public TaskQueue(boolean loadWorld, Class<P> clz, Map<DimensionType, IProcess<?, ?>> process, Supplier<SimpleTaskStorage<T>> storageProvider) {
        this.loadWorld = loadWorld;
        this.process = process;
        this.clz = clz;
        this.storageProvider = storageProvider;
    }

    public void populate(int size, Supplier<P> creator) {
        this.size = size;
        for (int i = 0; i < size; ++i) {
            this.generators.enqueue(creator.get());
        }
    }

    public boolean isEmpty() {
        return this.generators.isEmpty();
    }

    public void consume(Object entry) {
        if (this.clz.isInstance(entry)) {
            this.generators.enqueue(this.clz.cast(entry));
        }
    }

    public int removeTasks(String name) {
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        if (name != null && storage.removeTask(name)) {
            return 1;
        }
        if (name == null) {
            int size = storage.size();
            storage.clear();
            return size;
        }
        return 0;
    }

    public boolean startTask(T task, Consumer<ITextComponent> listener, MinecraftServer server) {
        if (task == null) {
            listener.accept(new StringTextComponent("Why the F..k is the task null?").func_211708_a(TextFormatting.RED));
            return false;
        }
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        if (!storage.addTask(task)) {
            listener.accept(new StringTextComponent("A Generation Task [" + task.getName() + "] already exists").func_211708_a(TextFormatting.GOLD));
            return false;
        }
        if (this.generators.isEmpty()) {
            listener.accept(new StringTextComponent("No Generators Available, Task is in Queue").func_211708_a(TextFormatting.AQUA));
            return false;
        }
        if (this.process.containsKey(task.getDimension())) {
            listener.accept(new StringTextComponent("Dimension already has a Task Active, Task is in Queue").func_211708_a(TextFormatting.AQUA));
            return false;
        }
        IProcess processor = (IProcess)this.generators.dequeue();
        this.process.put(task.getDimension(), processor);
        IProcess.PrepaireProgress progress = new IProcess.PrepaireProgress();
        processor.prepaireTask(progress, task.getName());
        storage.startTask(task.getName());
        task.createTask(DimensionManager.getWorld((MinecraftServer)server, (DimensionType)task.getDimension(), (boolean)true, (boolean)this.loadWorld), server.func_213207_aT(), progress).thenAcceptAsync(T -> {
            if (processor.startTask(task, T)) {
                listener.accept((ITextComponent)new StringTextComponent("Starting [" + task.getName() + "] Task"));
                return;
            }
            T.interrupt();
            listener.accept((ITextComponent)new StringTextComponent("Interrupted [" + task.getName() + "] Task"));
        }, (Executor)server);
        listener.accept((ITextComponent)new StringTextComponent("Prepairing [" + task.getName() + "] Task"));
        return true;
    }

    public boolean continueTask(String name, Consumer<ITextComponent> listener, MinecraftServer server) {
        if (this.generators.isEmpty() || this.process.size() >= this.size) {
            return false;
        }
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        Object task = storage.getTask(name);
        if (task == null) {
            return false;
        }
        if (this.process.containsKey(task.getDimension())) {
            return false;
        }
        IProcess processor = (IProcess)this.generators.dequeue();
        this.process.put(task.getDimension(), processor);
        IProcess.PrepaireProgress progress = new IProcess.PrepaireProgress();
        processor.prepaireTask(progress, task.getName());
        storage.startTask(name);
        task.createTask(DimensionManager.getWorld((MinecraftServer)server, (DimensionType)task.getDimension(), (boolean)true, (boolean)this.loadWorld), server.func_213207_aT(), progress).thenAcceptAsync(T -> {
            if (processor.startTask(task, T)) {
                listener.accept((ITextComponent)new StringTextComponent("Starting [" + task.getName() + "] Task"));
                return;
            }
            T.interrupt();
            listener.accept((ITextComponent)new StringTextComponent("Interrupted [" + task.getName() + "] Task"));
        }, (Executor)server);
        listener.accept((ITextComponent)new StringTextComponent("Prepairing [" + task.getName() + "] Task"));
        return true;
    }

    public boolean findNextTask(Consumer<ITextComponent> listener, MinecraftServer server, boolean ignoreFailLog) {
        if (this.generators.isEmpty()) {
            if (!ignoreFailLog) {
                listener.accept((ITextComponent)new StringTextComponent("No Generators Available"));
            }
            return false;
        }
        if (this.process.size() >= this.size) {
            if (!ignoreFailLog) {
                listener.accept((ITextComponent)new StringTextComponent("No Processor Space Available"));
            }
            return false;
        }
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        Object task = storage.getNextTask(this.process.keySet());
        if (task == null) {
            if (!ignoreFailLog) {
                listener.accept((ITextComponent)new StringTextComponent("No Tasks left"));
            }
            return false;
        }
        if (this.process.containsKey(task.getDimension())) {
            if (!ignoreFailLog) {
                listener.accept((ITextComponent)new StringTextComponent("Task Dimension is in Use [" + task.getDimension().getRegistryName().func_110623_a() + "]"));
            }
            return false;
        }
        IProcess processor = (IProcess)this.generators.dequeue();
        this.process.put(task.getDimension(), processor);
        IProcess.PrepaireProgress progress = new IProcess.PrepaireProgress();
        processor.prepaireTask(progress, task.getName());
        storage.startTask(task.getName());
        task.createTask(DimensionManager.getWorld((MinecraftServer)server, (DimensionType)task.getDimension(), (boolean)true, (boolean)this.loadWorld), server.func_213207_aT(), progress).thenAcceptAsync(T -> {
            if (processor.startTask(task, T)) {
                listener.accept((ITextComponent)new StringTextComponent("Starting [" + task.getName() + "] Task"));
                return;
            }
            T.interrupt();
            listener.accept((ITextComponent)new StringTextComponent("Interrupted [" + task.getName() + "] Task"));
        }, (Executor)server);
        listener.accept((ITextComponent)new StringTextComponent("Prepairing [" + task.getName() + "] Task"));
        return true;
    }
}

