/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.chunk.ChunkInfoAnswer;
import pregenerator.common.networking.chunk.ChunkInfoRequest;
import pregenerator.common.networking.chunk.ChunkTPAction;
import pregenerator.common.networking.chunk.ChunkTypeRemovalRequest;
import pregenerator.common.networking.chunk.ChunkTypeRequest;
import pregenerator.common.networking.command.ActionPacket;
import pregenerator.common.networking.command.DeletionPacket;
import pregenerator.common.networking.command.GenTaskListAnswer;
import pregenerator.common.networking.command.GenerationPacket;
import pregenerator.common.networking.command.RemoveTaskListAnswer;
import pregenerator.common.networking.command.RemoveTaskPacket;
import pregenerator.common.networking.command.SyncAnswerPacket;
import pregenerator.common.networking.command.SyncRequestPacket;
import pregenerator.common.networking.command.TaskListRequest;
import pregenerator.common.networking.dimrequests.DimensionInfoAnswer;
import pregenerator.common.networking.dimrequests.DimensionInfoRequest;
import pregenerator.common.networking.processing.ProcessorInfoAnswer;
import pregenerator.common.networking.processing.ProcessorInfoRequest;
import pregenerator.common.networking.retrogen.RetrogenChangeAnswer;
import pregenerator.common.networking.retrogen.RetrogenChangeRequest;
import pregenerator.common.networking.retrogen.RetrogenSyncAnswer;
import pregenerator.common.networking.retrogen.RetrogenSyncRequest;
import pregenerator.common.networking.tracking.TrackerInfoAnswer;
import pregenerator.common.networking.tracking.TrackerInfoRequest;
import pregenerator.common.networking.typeRequest.TypeInfoAnswer;
import pregenerator.common.networking.typeRequest.TypeInfoRequest;
import pregenerator.common.networking.typeRequest.TypeRemovalRequest;

public class NetworkManager {
    public static final NetworkManager INSTANCE = new NetworkManager();
    SimpleChannel channel;

    public void init() {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chunkpregen", "networking"), () -> "default", T -> true, T -> true);
        this.registerPacket(1, ProcessorInfoRequest.class, ProcessorInfoRequest::new);
        this.registerPacket(2, ProcessorInfoAnswer.class, ProcessorInfoAnswer::new);
        this.registerPacket(3, TrackerInfoRequest.class, TrackerInfoRequest::new);
        this.registerPacket(4, TrackerInfoAnswer.class, TrackerInfoAnswer::new);
        this.registerPacket(5, RetrogenChangeRequest.class, RetrogenChangeRequest::new);
        this.registerPacket(6, RetrogenChangeAnswer.class, RetrogenChangeAnswer::new);
        this.registerPacket(7, RetrogenSyncRequest.class, RetrogenSyncRequest::new);
        this.registerPacket(8, RetrogenSyncAnswer.class, RetrogenSyncAnswer::new);
        this.registerPacket(9, DimensionInfoRequest.class, DimensionInfoRequest::new);
        this.registerPacket(10, DimensionInfoAnswer.class, DimensionInfoAnswer::new);
        this.registerPacket(11, TypeInfoRequest.class, TypeInfoRequest::new);
        this.registerPacket(12, TypeInfoAnswer.class, TypeInfoAnswer::new);
        this.registerPacket(13, TypeRemovalRequest.class, TypeRemovalRequest::new);
        this.registerPacket(14, ChunkInfoRequest.class, ChunkInfoRequest::new);
        this.registerPacket(15, ChunkInfoAnswer.class, ChunkInfoAnswer::new);
        this.registerPacket(16, ChunkTypeRequest.class, ChunkTypeRequest::new);
        this.registerPacket(17, ChunkTPAction.class, ChunkTPAction::new);
        this.registerPacket(18, ChunkTypeRemovalRequest.class, ChunkTypeRemovalRequest::new);
        this.registerPacket(19, GenerationPacket.class, GenerationPacket::new);
        this.registerPacket(20, DeletionPacket.class, DeletionPacket::new);
        this.registerPacket(21, RemoveTaskPacket.class, RemoveTaskPacket::new);
        this.registerPacket(22, TaskListRequest.class, TaskListRequest::new);
        this.registerPacket(23, GenTaskListAnswer.class, GenTaskListAnswer::new);
        this.registerPacket(24, RemoveTaskListAnswer.class, RemoveTaskListAnswer::new);
        this.registerPacket(25, SyncRequestPacket.class, SyncRequestPacket::new);
        this.registerPacket(26, SyncAnswerPacket.class, SyncAnswerPacket::new);
        this.registerPacket(27, ActionPacket.class, ActionPacket::new);
    }

    public <T extends IPregenPacket> void registerPacket(int index, Class<T> packet, Supplier<T> creator) {
        this.channel.registerMessage(index, packet, this::writePacket, K -> this.readPacket((PacketBuffer)K, creator), this::handlePacket);
    }

    protected void writePacket(IPregenPacket packet, PacketBuffer buffer) {
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <T extends IPregenPacket> T readPacket(PacketBuffer buffer, Supplier<T> values) {
        try {
            IPregenPacket packet = (IPregenPacket)values.get();
            packet.read(buffer);
            return (T)packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void handlePacket(IPregenPacket packet, Supplier<NetworkEvent.Context> provider) {
        try {
            NetworkEvent.Context context = provider.get();
            PlayerEntity player = this.getPlayer(context);
            if (packet.requiresMainThread()) {
                context.enqueueWork(() -> {
                    packet.process(player);
                    context.setPacketHandled(true);
                });
            } else {
                packet.process(player);
                context.setPacketHandled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PlayerEntity getPlayer(NetworkEvent.Context cont) {
        ServerPlayerEntity entity = cont.getSender();
        return entity != null ? entity : this.getClientPlayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToServer(IPregenPacket packet) {
        this.channel.send(PacketDistributor.SERVER.noArg(), (Object)packet);
    }

    public void sendToAllPlayers(IPregenPacket packet) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public void sendToPlayer(IPregenPacket packet, PlayerEntity player) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)packet);
    }
}

