/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.PermissionAPI;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.chunk.ChunkInfoAnswer;
import pregenerator.common.tracker.ChunkEntry;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.tracker.WorldTracker;

public class ChunkInfoRequest
implements IPregenPacket {
    ResourceLocation dimension;

    public ChunkInfoRequest() {
    }

    public ChunkInfoRequest(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.dimension);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.dimension = buffer.func_192575_l();
    }

    @Override
    public void process(PlayerEntity player) {
        if (!PermissionAPI.hasPermission((PlayerEntity)player, (String)"pregen.chunkscraping")) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Not allowed to do a Detailed Scan"), false);
            NetworkManager.INSTANCE.sendToPlayer(new ChunkInfoAnswer(new byte[0]), player);
            return;
        }
        WorldTracker tracker = ServerTracker.INSTANCE.getWorldTracker(DimensionType.func_193417_a((ResourceLocation)this.dimension));
        if (tracker != null) {
            ChunkGatherer gatherer = new ChunkGatherer(tracker);
            ForkJoinPool.commonPool().invoke(gatherer);
            gatherer.quietlyJoin();
            NetworkManager.INSTANCE.sendToPlayer(new ChunkInfoAnswer(gatherer.getResult()), player);
            return;
        }
        NetworkManager.INSTANCE.sendToPlayer(new ChunkInfoAnswer(new byte[0]), player);
    }

    public static class ChunkGatherer
    extends RecursiveAction {
        private static final long serialVersionUID = 4071373671778321406L;
        WorldTracker tracker;
        byte[] result = new byte[0];

        public ChunkGatherer(WorldTracker tracker) {
            this.tracker = tracker;
        }

        @Override
        protected void compute() {
            List<Chunk> chunks = this.tracker.getChunks();
            if (chunks.isEmpty()) {
                this.result = new byte[0];
                return;
            }
            ObjectArrayList tasks = new ObjectArrayList();
            for (int i = 0; i < chunks.size(); ++i) {
                Chunk chunk = chunks.get(i);
                tasks.add(ForkJoinTask.adapt(() -> ChunkEntry.fromChunk(chunk)));
            }
            ChunkGatherer.invokeAll(tasks);
            ByteBuf buf = Unpooled.buffer();
            PacketBuffer buffer = new PacketBuffer(buf);
            buffer.func_150787_b(tasks.size());
            for (int i = 0; i < tasks.size(); ++i) {
                ((ChunkEntry)((ForkJoinTask)tasks.get(i)).getRawResult()).write(buffer);
            }
            this.result = new byte[buf.writerIndex()];
            buf.readBytes(this.result);
        }

        public byte[] getResult() {
            return this.result;
        }
    }
}

