/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.typeRequest;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.PermissionAPI;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.typeRequest.TypeInfoRequest;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.tracker.WorldTracker;

public class TypeRemovalRequest
implements IPregenPacket {
    int index;
    ResourceLocation dimension;
    ResourceLocation type;

    public TypeRemovalRequest() {
    }

    public TypeRemovalRequest(int index, ResourceLocation dimension, ResourceLocation type) {
        this.index = index;
        this.dimension = dimension;
        this.type = type;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.index);
        buffer.func_192572_a(this.dimension);
        buffer.func_192572_a(this.type);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.index = buffer.func_150792_a();
        this.dimension = buffer.func_192575_l();
        this.type = buffer.func_192575_l();
    }

    @Override
    public void process(PlayerEntity player) {
        if (!PermissionAPI.hasPermission((PlayerEntity)player, (String)"pregen.mass.deletion")) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Not Enough Permission to do such Action"), false);
            return;
        }
        WorldTracker tracker = ServerTracker.INSTANCE.getWorldTracker(DimensionType.func_193417_a((ResourceLocation)this.dimension));
        if (tracker == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Dimension is Unloaded"), false);
            return;
        }
        int deleted = 0;
        switch (this.index) {
            case 0: {
                ObjectArrayList toRemove = new ObjectArrayList();
                for (TileEntity tile : tracker.getWorld().field_147482_g) {
                    if (!tile.func_200662_C().getRegistryName().equals((Object)this.type)) continue;
                    toRemove.add(tile);
                }
                for (TileEntity tile : toRemove) {
                    tracker.getWorld().func_217377_a(tile.func_174877_v(), false);
                    ++deleted;
                }
                break;
            }
            case 1: {
                Iterator iter = tracker.getWorld().getEntities().iterator();
                while (iter.hasNext()) {
                    Entity entity = (Entity)iter.next();
                    if (!entity.func_200600_R().getRegistryName().equals((Object)this.type)) continue;
                    entity.func_70106_y();
                    ++deleted;
                }
                break;
            }
        }
        player.func_146105_b((ITextComponent)new StringTextComponent("Removed " + deleted + " of [" + ChunkLogger.toPascalCase(this.type.func_110623_a()) + "]"), false);
        new TypeInfoRequest(this.index, this.dimension).process(player);
    }
}

