/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.RegionSectionCache;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.utils.misc.AverageCounter;
import pregenerator.common.utils.misc.ReflectionHelper;
import pregenerator.common.utils.misc.TimeTracker;

public class WorldTracker {
    static final Method CHUNK_GETTER = ReflectionHelper.findMethod(ChunkManager.class, new String[]{"getLoadedChunksIterable", "func_223491_f"}, new Class[0]);
    ServerWorld world;
    TimeTracker timer = new TimeTracker(40);
    AverageCounter blockUpdates = new AverageCounter(40);
    AverageCounter blockTicks = new AverageCounter(40);
    AverageCounter fluidTicks = new AverageCounter(40);
    Long2ObjectMap<Optional<PointOfInterestData>> pointsOfInterest;

    public WorldTracker(ServerWorld world) {
        this.world = world;
        this.pointsOfInterest = (Long2ObjectMap)ReflectionHelper.getValueSave(RegionSectionCache.class, world.func_217443_B(), new String[]{"data", "field_219121_b"});
        if (this.pointsOfInterest == null) {
            this.pointsOfInterest = new Long2ObjectOpenHashMap();
        }
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    public void start() {
        this.timer.start();
        this.blockTicks.addMore(this.world.func_205220_G_().func_225420_a());
        this.blockTicks.onFinished();
        this.fluidTicks.addMore(this.world.func_205219_F_().func_225420_a());
        this.fluidTicks.onFinished();
    }

    public void stop() {
        this.timer.finish();
        this.blockUpdates.onFinished();
    }

    public void onBlockUpdate() {
        this.blockUpdates.addOne();
    }

    public long getAverageLag() {
        return this.timer.getAverage();
    }

    public List<Chunk> getChunks() {
        try {
            ObjectArrayList chunks = new ObjectArrayList();
            for (ChunkHolder holder : (Iterable)CHUNK_GETTER.invoke((Object)this.world.func_72863_F().field_217237_a, new Object[0])) {
                Optional entry = holder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                if (!entry.isPresent()) continue;
                chunks.add(entry.get());
            }
            return chunks;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public Chunk getChunk(long chunkPos) {
        return this.world.func_212866_a_(ChunkPos.func_212578_a((long)chunkPos), ChunkPos.func_212579_b((long)chunkPos));
    }

    public void writeTrackingData(PacketBuffer buffer) {
        buffer.writeInt(this.world.func_201675_m().func_186058_p().func_186068_a());
        buffer.func_179254_b(this.timer.getAverage());
        buffer.func_179254_b(this.timer.getLastValue());
        buffer.func_150787_b(this.world.field_147482_g.size());
        buffer.func_150787_b(this.world.field_175730_i.size());
        buffer.func_150787_b(this.world.func_72863_F().func_73152_e());
        buffer.func_150787_b(this.pointsOfInterest.size());
        buffer.func_150787_b((int)this.world.getEntities().count());
        buffer.func_150787_b(this.blockUpdates.getAverage());
        buffer.func_150787_b(this.blockUpdates.getLast());
        buffer.func_150787_b(this.blockTicks.getAverage());
        buffer.func_150787_b(this.blockTicks.getLast());
        buffer.func_150787_b(this.fluidTicks.getAverage());
        buffer.func_150787_b(this.fluidTicks.getLast());
    }
}

