/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.multiblocks;

import com.mcwroofs.kikoz.objects.multiblocks.LowerRoofParts;
import com.mcwroofs.kikoz.objects.roofs.RoofBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SteepRoof
extends RoofBase
implements IWaterLoggable {
    public static final EnumProperty<LowerRoofParts> HALF = EnumProperty.func_177709_a((String)"half", LowerRoofParts.class);
    protected static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SteepRoof(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)((Object)LowerRoofParts.BOTTOM))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public SteepRoof() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(1.0f, 50.0f));
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public int getHarvestLevel(BlockState state) {
        return 1;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            IFluidState fluidState = world.func_204610_c(pos.func_177984_a());
            world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(HALF, (Comparable)((Object)LowerRoofParts.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a)), 1);
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos clonerPartPos;
        Direction facing = (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        BlockPos clonerPos = this.getClonerPos(pos, (LowerRoofParts)((Object)state.func_177229_b(HALF)), facing);
        BlockState clonerBlockState = world.func_180495_p(clonerPos);
        if (clonerBlockState.func_177230_c() == this && !pos.equals((Object)clonerPos)) {
            this.removeHalf(world, clonerPos, clonerBlockState);
        }
        if ((clonerBlockState = world.func_180495_p(clonerPartPos = this.getClonerTopPos(clonerPos, facing))).func_177230_c() == this && !pos.equals((Object)clonerPartPos)) {
            this.removeHalf(world, clonerPartPos, clonerBlockState);
        }
        super.func_176208_a(world, pos, state, player);
    }

    private BlockPos getClonerTopPos(BlockPos base, Direction facing) {
        switch (facing) {
            default: 
        }
        return base.func_177984_a();
    }

    private BlockPos getClonerPos(BlockPos pos, LowerRoofParts part, Direction facing) {
        if (part == LowerRoofParts.BOTTOM) {
            return pos;
        }
        switch (facing) {
            default: 
        }
        return pos.func_177977_b();
    }

    private void removeHalf(World world, BlockPos pos, BlockState state) {
        IFluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos clonerPos = this.getClonerTopPos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && clonerPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(HALF, (Comparable)((Object)LowerRoofParts.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    @Override
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF, HorizontalBlock.field_185512_D, WATERLOGGED});
    }
}

