/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.util;

import com._idrae.towers_of_the_wild.TowersOfTheWild;
import com._idrae.towers_of_the_wild.world.structures.DerelictTowerGrassPieces;
import com._idrae.towers_of_the_wild.world.structures.DerelictTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.IceTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.JungleTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.TowerPieces;
import com._idrae.towers_of_the_wild.world.structures.TowerStructure;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistryHandler {
    public static final DeferredRegister<Feature<?>> FEATURES = new DeferredRegister(ForgeRegistries.FEATURES, "towers_of_the_wild");
    public static final RegistryObject<Structure<NoFeatureConfig>> TOWER = RegistryHandler.registerStructure("tower", new TowerStructure(NoFeatureConfig::func_214639_a));
    public static final IStructurePieceType TOWER_PIECE = RegistryHandler.registerPiece("tower", TowerPieces.Piece::new);
    public static final IStructurePieceType JUNGLE_TOWER_PIECE = RegistryHandler.registerPiece("jungle_tower", JungleTowerPieces.Piece::new);
    public static final IStructurePieceType ICE_TOWER_PIECE = RegistryHandler.registerPiece("ice_tower", IceTowerPieces.Piece::new);
    public static final IStructurePieceType DERELICT_TOWER_PIECE = RegistryHandler.registerPiece("derelict_tower", DerelictTowerPieces.Piece::new);
    public static final IStructurePieceType DERELICT_TOWER_GRASS_PIECE = RegistryHandler.registerPiece("derelict_tower_grass", DerelictTowerGrassPieces.Piece::new);

    private static <T extends Feature<?>> RegistryObject<T> registerStructure(String name, T feature) {
        TowersOfTheWild.LOGGER.info(name + " structure registered");
        return FEATURES.register(name, () -> feature);
    }

    private static IStructurePieceType registerPiece(String key, IStructurePieceType type) {
        TowersOfTheWild.LOGGER.info(key + " structure piece registered");
        return (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("towers_of_the_wild", key), (Object)type);
    }
}

