/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.world.structures;

import com._idrae.towers_of_the_wild.config.TowersOfTheWildConfig;
import com._idrae.towers_of_the_wild.util.RegistryHandler;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.fml.ModList;

public class IceTowerPieces {
    private static final ResourceLocation TOWER_TOP = ModList.get().isLoaded("waystones") && TowersOfTheWildConfig.waystonesCompat ? new ResourceLocation("towers_of_the_wild", "waystone_tower_top") : new ResourceLocation("towers_of_the_wild", "tower_top");
    private static final ResourceLocation ICE_TOWER_BOTTOM = new ResourceLocation("towers_of_the_wild", "ice_tower_bottom");
    private static final ResourceLocation TOWER_CHEST = new ResourceLocation("towers_of_the_wild", "chests/tower_chest");
    private static final Map<ResourceLocation, BlockPos> CENTER_TOP_OFFSETS = ImmutableMap.of((Object)TOWER_TOP, (Object)new BlockPos(6, 28, 6), (Object)ICE_TOWER_BOTTOM, (Object)new BlockPos(5, 31, 5));
    private static final Map<ResourceLocation, BlockPos> CORNER_RELATIVE_POSITIONS = ImmutableMap.of((Object)TOWER_TOP, (Object)new BlockPos(-1, 31, -1), (Object)ICE_TOWER_BOTTOM, (Object)BlockPos.field_177992_a);

    public static void addPieces(TemplateManager templateManager, BlockPos absolutePos, Rotation rotation, List<StructurePiece> pieces, Random random, NoFeatureConfig config) {
        pieces.add((StructurePiece)new Piece(templateManager, ICE_TOWER_BOTTOM, absolutePos, rotation));
        pieces.add((StructurePiece)new Piece(templateManager, TOWER_TOP, absolutePos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation structurePart;
        private final Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation structurePart, BlockPos absolutePos, Rotation rotation) {
            super(RegistryHandler.ICE_TOWER_PIECE, 0);
            this.structurePart = structurePart;
            BlockPos relativePos = (BlockPos)CORNER_RELATIVE_POSITIONS.get(structurePart);
            this.field_186178_c = absolutePos.func_177982_a(relativePos.func_177958_n(), relativePos.func_177956_o(), relativePos.func_177952_p());
            this.rotation = rotation;
            this.func_207614_a(templateManager);
        }

        public Piece(TemplateManager p_i50566_1_, CompoundNBT p_i50566_2_) {
            super(RegistryHandler.ICE_TOWER_PIECE, p_i50566_2_);
            this.structurePart = new ResourceLocation(p_i50566_2_.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)p_i50566_2_.func_74779_i("Rot"));
            this.func_207614_a(p_i50566_1_);
        }

        private void func_207614_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.structurePart);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_TOP_OFFSETS.get(this.structurePart));
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.structurePart.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity).func_189404_a(TOWER_CHEST, rand.nextLong());
                }
            }
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_TOP_OFFSETS.get(this.structurePart));
            BlockPos relativePos = (BlockPos)CORNER_RELATIVE_POSITIONS.get(this.structurePart);
            if (this.structurePart.equals((Object)ICE_TOWER_BOTTOM)) {
                int j;
                int i;
                BlockPos blockpos1 = this.field_186178_c;
                int minHeight = Integer.MAX_VALUE;
                for (i = 1; i < 8; ++i) {
                    for (j = 1; j < 8; ++j) {
                        int height = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n() + i, blockpos1.func_177952_p() + j);
                        if (height >= minHeight) continue;
                        minHeight = height;
                    }
                }
                for (i = 0; i < 9; ++i) {
                    for (j = 0; j < 9; ++j) {
                        BlockPos snowPos;
                        BlockPos grassPos = new BlockPos(blockpos1.func_177958_n() + i, minHeight - 1, blockpos1.func_177952_p() + j);
                        BlockState blockstate = worldIn.func_180495_p(grassPos);
                        if (blockstate.func_177230_c() == Blocks.field_150346_d) {
                            worldIn.func_180501_a(grassPos, Blocks.field_196658_i.func_176223_P(), 3);
                        }
                        if ((i != 0 && i != 8 || j != 0 && j != 8) && blockstate.func_177230_c() == Blocks.field_150355_j) {
                            worldIn.func_180501_a(grassPos, Blocks.field_196658_i.func_176223_P(), 3);
                        }
                        if (worldIn.func_180495_p(snowPos = grassPos.func_177982_a(0, 1, 0)).func_177230_c() != Blocks.field_150350_a) continue;
                        worldIn.func_180501_a(snowPos, Blocks.field_150433_aE.func_176223_P(), 3);
                    }
                }
                this.field_186178_c = this.field_186178_c.func_177982_a(0, minHeight - 90, 0);
            } else if (this.structurePart.equals((Object)TOWER_TOP)) {
                BlockPos blockpos1 = this.field_186178_c;
                int minHeight = Integer.MAX_VALUE;
                for (int i = 1; i < 8; ++i) {
                    for (int j = 1; j < 8; ++j) {
                        int height = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n() + 1 + i, blockpos1.func_177952_p() + 1 + j);
                        if (height >= minHeight) continue;
                        minHeight = height;
                    }
                }
                this.field_186178_c = this.field_186178_c.func_177982_a(0, minHeight - 90, 0);
            }
            return super.func_225577_a_(worldIn, chunkGeneratorIn, randomIn, mutableBoundingBoxIn, chunkPosIn);
        }
    }
}

