/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import com.mushroom.midnight.common.particle.ParticleDataOneInt;
import com.mushroom.midnight.common.util.MidnightUtil;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FadingSporeParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite spriteSet;
    private final float scaleMax;

    private FadingSporeParticle(IAnimatedSprite spriteSet, World world, double x, double y, double z, double motionX, double motionY, double motionZ, int color) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY + 0.01;
        this.field_187131_k = motionZ;
        float[] rgbF = MidnightUtil.getRGBColorF(color);
        this.func_70538_b(MathHelper.func_76131_a((float)(rgbF[0] + (this.field_187136_p.nextFloat() * 0.2f - 0.1f)), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(rgbF[1] + (this.field_187136_p.nextFloat() * 0.2f - 0.1f)), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(rgbF[2] + (this.field_187136_p.nextFloat() * 0.2f - 0.1f)), (float)0.0f, (float)1.0f));
        this.field_82339_as = 1.0f;
        this.field_70544_f = 0.0f;
        this.scaleMax = world.field_73012_v.nextFloat() * 0.5f + 0.5f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.field_190017_n = false;
        this.field_70545_g = 0.0f;
        this.spriteSet = spriteSet;
        this.func_217566_b(this.spriteSet);
    }

    public void func_189213_a() {
        this.func_217568_a(this.spriteSet);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (++this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= 0.9;
            this.field_187131_k *= 0.9;
            float ratio = (float)this.field_70546_d / (float)this.field_70547_e;
            if (ratio <= 0.25f) {
                this.field_70544_f = this.scaleMax * ratio * 0.2f;
            } else {
                float ratio2;
                this.field_82339_as = ratio2 = ratio / 0.75f;
                this.field_70544_f = this.scaleMax * (1.0f - ratio2) * 0.05f;
            }
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public int func_189214_a(float partialTick) {
        int skylight = 10;
        int blocklight = 5;
        return skylight << 20 | blocklight << 4;
    }

    public static class Factory
    implements IParticleFactory<ParticleDataOneInt> {
        private IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(ParticleDataOneInt particleType, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FadingSporeParticle(this.spriteSet, world, x, y, z, xSpeed, ySpeed, zSpeed, particleType.oneInt);
        }
    }
}

