/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mushroom.midnight.common.util.MidnightUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class EmissiveLayerRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private final ResourceLocation texture;
    private final BrightnessFunction<T> brightnessFunction;
    private final ColorFunction<T> colorFunction;

    public EmissiveLayerRenderer(IEntityRenderer<T, M> renderer, ResourceLocation texture, BrightnessFunction<T> brightnessFunction, ColorFunction<T> colorFunction) {
        super(renderer);
        this.texture = texture;
        this.brightnessFunction = brightnessFunction;
        this.colorFunction = colorFunction;
    }

    public EmissiveLayerRenderer(IEntityRenderer<T, M> renderer, ResourceLocation texture, BrightnessFunction<T> brightnessFunction) {
        this(renderer, texture, brightnessFunction, (entity, partialTicks) -> 0xFFFFFF);
    }

    public EmissiveLayerRenderer(IEntityRenderer<T, M> renderer, ResourceLocation texture) {
        this(renderer, texture, (entity, partialTicks) -> 240);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entitylivingbaseIn.func_82150_aj()) {
            return;
        }
        CLIENT.func_110434_K().func_110577_a(this.texture);
        int brightness = this.brightnessFunction.apply(entitylivingbaseIn, partialTicks);
        float[] rgbF = MidnightUtil.getRGBColorF(this.colorFunction.getColor(entitylivingbaseIn, partialTicks));
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.texture));
        this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, brightness, OverlayTexture.field_229196_a_, rgbF[0], rgbF[1], rgbF[2], 1.0f);
    }

    public static interface ColorFunction<T extends LivingEntity> {
        public int getColor(T var1, float var2);
    }

    public static interface BrightnessFunction<T extends LivingEntity> {
        public int apply(T var1, float var2);
    }
}

