/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config.ifc;

import com.mushroom.midnight.client.gui.config.widget.IConfigWidget;
import com.mushroom.midnight.common.config.ifc.IConfigControlType;
import com.mushroom.midnight.common.config.provider.IConfigValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IntInputControl
implements IConfigControlType<Integer> {
    private final int min;
    private final int max;

    public IntInputControl(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IConfigWidget<Integer> createConfigWidget(IConfigValue<Integer> configValue) {
        return new CfgWidget(configValue, this.min, this.max);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class CfgWidget
    implements IConfigWidget<Integer> {
        private final IConfigValue<Integer> configValue;
        private final TextFieldWidget input;
        private final int min;
        private final int max;
        private static final int RED_COLOR = 0xFF5555;
        private static final int AQUA_COLOR = 0x55FFFF;

        private CfgWidget(IConfigValue<Integer> configValue, int min, int max) {
            this.configValue = configValue;
            this.min = min;
            this.max = max;
            this.input = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 150, 20, "");
            this.input.func_146180_a(configValue.get() + "");
            this.input.func_212954_a(this::handleInput);
        }

        private void handleInput(String value) {
            Integer parsed = this.lazyParse(value);
            this.input.func_146193_g(0x55FFFF);
            if (parsed == null) {
                this.input.func_146193_g(0xFF5555);
            } else {
                this.configValue.set(parsed);
            }
        }

        private Integer lazyParse(String value) {
            try {
                int i = Integer.parseInt(value);
                return i >= this.min && i <= this.max ? Integer.valueOf(i) : null;
            }
            catch (NumberFormatException exc) {
                return null;
            }
        }

        @Override
        public IConfigValue<Integer> getConfigValue() {
            return this.configValue;
        }

        @Override
        public Widget asWidget() {
            return this.input;
        }
    }
}

