/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.entity.FlyingNavigator;
import com.mushroom.midnight.common.entity.task.HunterIdleGoal;
import com.mushroom.midnight.common.entity.task.HunterSwoopGoal;
import com.mushroom.midnight.common.entity.task.HunterTargetGoal;
import com.mushroom.midnight.common.entity.task.HunterTrackGoal;
import com.mushroom.midnight.common.registry.MidnightEffects;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.util.MeanValueRecorder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class HunterEntity
extends MonsterEntity
implements IFlyingAnimal {
    private final AnimationCapability animCap = new AnimationCapability();
    public static final int FLIGHT_HEIGHT = 40;
    public float roll;
    public float prevRoll;
    public int swoopCooldown;
    public int flapTime;
    private final MeanValueRecorder deltaYaw = new MeanValueRecorder(20);

    public HunterEntity(EntityType<? extends HunterEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new MoveHelper(this);
        this.field_70749_g = new LookHelper((MobEntity)this);
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingNavigator navigator = new FlyingNavigator((MobEntity)this, world);
        navigator.func_192879_a(false);
        navigator.func_212239_d(false);
        navigator.func_192878_b(false);
        return navigator;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return this.func_180425_c().func_177956_o() > this.field_70170_p.func_181545_F();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.12);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new HunterSwoopGoal(this, 1.3));
        this.field_70714_bg.func_75776_a(2, (Goal)new HunterTrackGoal(this, 0.7));
        this.field_70714_bg.func_75776_a(100, (Goal)new HunterIdleGoal(this, 0.6));
        this.field_70715_bh.func_75776_a(1, new HunterTargetGoal<PlayerEntity>((CreatureEntity)this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(2, new HunterTargetGoal<AnimalEntity>((CreatureEntity)this, AnimalEntity.class));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.swoopCooldown > 0) {
                --this.swoopCooldown;
            }
        } else {
            this.deltaYaw.record(this.field_70177_z - this.field_70126_B);
            float deltaYaw = this.deltaYaw.computeMean();
            this.prevRoll = this.roll;
            this.roll = MathHelper.func_76131_a((float)(-deltaYaw * 8.0f), (float)-45.0f, (float)45.0f);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean grounded, BlockState state, BlockPos pos) {
    }

    public void func_213352_e(Vec3d direction) {
        if (this.func_70613_aW() || this.func_184186_bw()) {
            double speed = (double)this.func_70689_ay() * 0.3;
            Vec3d lookVector = this.func_70040_Z();
            Vec3d moveVector = lookVector.func_72432_b().func_186678_a(speed);
            this.func_213317_d(this.func_213322_ci().func_178787_e(moveVector).func_186678_a(0.91));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        this.updateLimbs();
    }

    private void updateLimbs() {
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.func_226277_ct_() - this.field_70169_q;
        double deltaY = this.func_226278_cu_() - this.field_70167_r;
        double deltaZ = this.func_226281_cx_() - this.field_70166_s;
        float distance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        float moveAmount = Math.min(distance * 4.0f, 1.0f);
        this.field_70721_aZ += (moveAmount - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
        ++this.flapTime;
        if (this.flapTime >= 15 && moveAmount >= 0.4f) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), MidnightSounds.HUNTER_FLYING, SoundCategory.HOSTILE, 0.15f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
            this.flapTime = 0;
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                float theta = (float)Math.toRadians(this.field_70177_z);
                living.func_70653_a((Entity)this, 0.3f, (double)MathHelper.func_76126_a((float)theta), (double)(-MathHelper.func_76134_b((float)theta)));
                if (this.field_70146_Z.nextInt(2) == 0) {
                    living.func_195064_c(new EffectInstance(MidnightEffects.TORMENTED, 120));
                }
                this.animCap.setAnimation((Entity)this, AnimationCapability.Type.ATTACK, 10);
                this.swoopCooldown += 120;
            }
            return true;
        }
        this.swoopCooldown += 160;
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if ((source.func_76352_a() || source.func_76364_f() instanceof LivingEntity) && this.swoopCooldown <= 20) {
            this.swoopCooldown += 120;
        }
        return super.func_70097_a(source, amount);
    }

    public int func_70641_bl() {
        return 1;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).isAir((IBlockReader)worldIn, pos) ? 10.0f : 0.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MidnightSounds.HUNTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MidnightSounds.HUNTER_DEATH;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.animCap.updateAnimation();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == Midnight.ANIMATION_CAP ? LazyOptional.of(() -> this.animCap).cast() : LazyOptional.empty();
    }

    private static class LookHelper
    extends LookController {
        private final MobEntity parent;

        LookHelper(MobEntity parent) {
            super(parent);
            this.parent = parent;
        }

        public void func_75649_a() {
            if (this.field_75655_d) {
                this.field_75655_d = false;
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.func_220678_h(), this.field_75657_b);
                this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, this.func_220677_g(), this.field_75658_c);
            } else {
                if (this.field_75659_a.func_70661_as().func_75500_f()) {
                    this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, 0.0f, 5.0f);
                }
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.field_75659_a.field_70761_aq, this.field_75657_b);
            }
            float deltaYaw = MathHelper.func_76142_g((float)(this.parent.field_70759_as - this.parent.field_70761_aq));
            if (!this.parent.func_70661_as().func_75500_f()) {
                if (deltaYaw < -75.0f) {
                    this.parent.field_70759_as = this.parent.field_70761_aq - 75.0f;
                }
                if (deltaYaw > 75.0f) {
                    this.parent.field_70759_as = this.parent.field_70761_aq + 75.0f;
                }
            }
        }
    }

    private static class MoveHelper
    extends MovementController {
        private static final float CLOSE_TURN_SPEED = 150.0f;
        private static final float FAR_TURN_SPEED = 6.5f;
        private static final float CLOSE_TURN_DISTANCE = 2.0f;
        private static final float FAR_TURN_DISTANCE = 7.0f;

        private MoveHelper(HunterEntity parent) {
            super((MobEntity)parent);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                this.field_75648_a.func_189654_d(true);
                double d0 = this.field_75646_b - this.field_75648_a.func_226277_ct_();
                double d1 = this.field_75647_c - this.field_75648_a.func_226278_cu_();
                double d2 = this.field_75644_d - this.field_75648_a.func_226281_cx_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_70657_f(0.0f);
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float distance = MathHelper.func_76133_a((double)d3);
                float turnSpeed = this.computeTurnSpeed(distance);
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, turnSpeed);
                this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z;
                double flySpeed = this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e();
                float resultSpeed = (float)(this.field_75645_e * flySpeed);
                this.field_75648_a.func_70659_e(resultSpeed);
                double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f2 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d4) * 57.2957763671875));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f2, turnSpeed);
                this.field_75648_a.func_70657_f(d1 > 0.0 ? resultSpeed : -resultSpeed);
            } else {
                this.field_75648_a.func_70657_f(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
            }
        }

        private float computeTurnSpeed(float distance) {
            float lerpRange = 5.0f;
            float alpha = MathHelper.func_76131_a((float)((distance - 2.0f) / lerpRange), (float)0.0f, (float)1.0f);
            float turnSpeed = 150.0f + -143.5f * alpha;
            return turnSpeed * (float)this.field_75645_e;
        }
    }
}

