/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.entity.creature.GrowableEntity;
import com.mushroom.midnight.common.entity.task.NeutralGoal;
import com.mushroom.midnight.common.registry.MidnightSounds;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class StingerEntity
extends GrowableEntity
implements IMob {
    private final AnimationCapability animCap = new AnimationCapability();

    public StingerEntity(EntityType<? extends StingerEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    @Override
    public int getMaxGrowingAge() {
        return 5;
    }

    @Override
    public int getGrowingTimeByAge() {
        return 1200;
    }

    @Override
    protected void onGrowingToAge(int age) {
        float maxHealth = 10.0f + (float)age * 4.0f;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        this.func_70606_j(maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 + (double)age);
        if (age > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)age);
        }
        if (age == this.getMaxGrowingAge()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new NeutralGoal(this, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]), false));
            this.field_70715_bh.func_75776_a(2, (Goal)new NeutralGoal(this, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true, false), false));
        }
    }

    @Override
    @Nullable
    public GrowableEntity createChild(GrowableEntity growable) {
        return null;
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundPathNavigator((MobEntity)this, world);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (this.func_180425_c().func_177956_o() > 50) {
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70631_g_();
    }

    public boolean func_70617_f_() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return MidnightSounds.STINGER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return MidnightSounds.STINGER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MidnightSounds.STINGER_DEATH;
    }

    public int func_70627_aG() {
        return 100;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new NeutralGoal(this, (Goal)new PanicGoal((CreatureEntity)this, 1.2), true));
        this.field_70714_bg.func_75776_a(2, (Goal)new NeutralGoal(this, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7, 0.005f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NeutralGoal(this, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]), false));
        this.field_70715_bh.func_75776_a(2, (Goal)new NeutralGoal(this, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true, true), false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (flag) {
            if (!this.func_70631_g_()) {
                int age = this.getGrowingAge();
                ((PlayerEntity)entity).func_195064_c(new EffectInstance(Effects.field_76437_t, 100, age == this.getMaxGrowingAge() ? 2 : (age > 2 ? 1 : 0), false, true));
            }
            this.func_174815_a((LivingEntity)this, entity);
            this.animCap.setAnimation((Entity)this, AnimationCapability.Type.ATTACK, 10);
        }
        return flag;
    }

    public void func_184609_a(Hand hand) {
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT dataTag) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.setGrowingAge(-1);
        }
        return livingdata;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 5 + this.getGrowingAge() * 2;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.animCap.updateAnimation();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == Midnight.ANIMATION_CAP ? LazyOptional.of(() -> this.animCap).cast() : LazyOptional.empty();
    }
}

