/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.projectile;

import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightParticleTypes;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class NovaSpikeEntity
extends ThrowableEntity {
    private float damage = 4.0f;
    @Nullable
    private BlockState inBlockState;
    protected boolean field_174854_a;
    protected int timeInGround;
    private int ticksInGround;
    private int ticksInAir;

    public NovaSpikeEntity(World world) {
        super(MidnightEntities.NOVA_SPIKE, world);
    }

    public NovaSpikeEntity(EntityType<NovaSpikeEntity> entityType, World world) {
        super(entityType, world);
        this.setDamage(this.damage);
    }

    public NovaSpikeEntity(World world, double x, double y, double z) {
        super(MidnightEntities.NOVA_SPIKE, x, y, z, world);
        this.setDamage(this.damage);
        this.func_70107_b(x, y, z);
    }

    public NovaSpikeEntity(World world, LivingEntity thrower) {
        super(MidnightEntities.NOVA_SPIKE, thrower, world);
        this.setDamage(this.damage);
    }

    public NovaSpikeEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(MidnightEntities.NOVA_SPIKE, world);
    }

    protected void func_70184_a(RayTraceResult result) {
        BlockPos blockpos;
        BlockRayTraceResult blockraytraceresult;
        BlockState blockstate;
        LivingEntity thrower = this.func_85052_h();
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            int fireTimer = entity.func_223314_ad();
            DamageSource damage = thrower == null ? DamageSource.func_76356_a((Entity)this, (Entity)this) : DamageSource.func_76356_a((Entity)this, (Entity)thrower);
            if (entity.func_70097_a(damage, this.getDamage())) {
                this.func_70106_y();
            } else {
                entity.func_223308_g(fireTimer);
                this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                    this.func_70106_y();
                }
            }
        } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK && !(blockstate = this.field_70170_p.func_180495_p((blockraytraceresult = (BlockRayTraceResult)result).func_216350_a())).func_196952_d((IBlockReader)this.field_70170_p, blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_())).func_197766_b()) {
            this.inBlockState = blockstate;
            Vec3d vec3d = blockraytraceresult.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.func_213317_d(vec3d);
            Vec3d vec3d1 = vec3d.func_72432_b().func_186678_a((double)0.05f);
            this.func_70107_b((double)this.func_180425_c().func_177958_n() - vec3d1.field_72450_a, (double)this.func_180425_c().func_177956_o() - vec3d1.field_72448_b, (double)this.func_180425_c().func_177952_p() - vec3d1.field_72449_c);
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_174854_a = true;
            blockstate.func_215690_a(this.field_70170_p, blockstate, blockraytraceresult, (Entity)this);
        }
    }

    public void func_70071_h_() {
        Vec3d motion = this.func_213322_ci();
        BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c());
        if (this.field_174854_a) {
            if (this.inBlockState != state && !this.field_70170_p.func_72829_c(this.func_174813_aQ().func_186662_g(0.06))) {
                this.field_174854_a = false;
                this.func_213317_d(motion.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.tryDespawn();
            }
            ++this.timeInGround;
        } else {
            super.func_70071_h_();
            this.func_145775_I();
            this.field_70170_p.func_195594_a((IParticleData)MidnightParticleTypes.SPORE, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.05, 0.0);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlockState));
        }
        compound.func_74774_a("inGround", (byte)(this.field_174854_a ? 1 : 0));
        compound.func_74776_a("damage", this.damage);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.ticksInGround = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        boolean bl = this.field_174854_a = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74760_g("damage");
        }
    }

    protected void tryDespawn() {
        ++this.ticksInGround;
        if (this.ticksInGround >= 300) {
            this.func_70106_y();
        }
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    protected void func_70088_a() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

