/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import com.mushroom.midnight.Midnight;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityReference<T extends Entity> {
    private final World world;
    @Nullable
    private UUID entityId;
    @Nullable
    private WeakReference<T> cachedEntity;
    private long lastLookupTime;

    public EntityReference(World world) {
        this.world = world;
    }

    public void set(T entity) {
        this.entityId = entity.func_110124_au();
        this.cachedEntity = new WeakReference<T>(entity);
    }

    public Optional<T> deref(boolean forceLoad) {
        if (!(this.world instanceof ServerWorld)) {
            throw new IllegalStateException("Cannot dereference entity reference on client");
        }
        if (this.entityId == null) {
            return Optional.empty();
        }
        T cached = this.getCachedEntity();
        if (cached != null && !cached.func_70089_S()) {
            this.cachedEntity = null;
            return Optional.empty();
        }
        if (cached != null) {
            return Optional.of(cached);
        }
        long totalWorldTime = this.world.func_82737_E();
        if (forceLoad || totalWorldTime - this.lastLookupTime > 20L) {
            Entity entity = ((ServerWorld)this.world).func_217461_a(this.entityId);
            if (entity != null) {
                this.updateCachedEntity(entity);
            }
            this.lastLookupTime = totalWorldTime;
        }
        return Optional.ofNullable(this.getCachedEntity());
    }

    public boolean isPresent() {
        return this.deref(false).isPresent();
    }

    private void updateCachedEntity(Entity entity) {
        try {
            this.cachedEntity = new WeakReference<Entity>(entity);
        }
        catch (ClassCastException e) {
            Midnight.LOGGER.warn("Entity contained reference to entity of unexpected type! {}", (Object)entity);
            this.cachedEntity = null;
        }
    }

    @Nullable
    private T getCachedEntity() {
        return (T)(this.cachedEntity != null ? (Entity)this.cachedEntity.get() : null);
    }

    public CompoundNBT serialize(CompoundNBT compound) {
        if (this.entityId != null) {
            compound.func_186854_a("uuid", this.entityId);
        }
        return compound;
    }

    public void deserialize(CompoundNBT compound) {
        this.entityId = compound.func_186855_b("uuid") ? compound.func_186857_a("uuid") : null;
    }
}

